/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.annotations.Bind;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.paranamer.CachingParanamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleMemberInjector<T>
extends AbstractInjector<T> {
    private transient CachingParanamer paranamer = new CachingParanamer();

    public SingleMemberInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy, boolean useNames) {
        super(componentKey, componentImplementation, parameters, monitor, lifecycleStrategy, useNames);
    }

    protected CachingParanamer getParanamer() {
        return this.paranamer;
    }

    protected Object[] getMemberArguments(PicoContainer container, AccessibleObject member, Type[] parameterTypes, Annotation[] bindings) {
        this.boxParameters(parameterTypes);
        Object[] result = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result[i] = this.getParameter(container, member, i, parameterTypes[i], bindings[i], currentParameters[i]);
        }
        return result;
    }

    private void boxParameters(Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.box(parameterTypes[i]);
        }
    }

    private Object getParameter(PicoContainer container, AccessibleObject member, int i, Type parameterType, Annotation binding, Parameter currentParameter) {
        ParameterNameBinding expectedNameBinding = new ParameterNameBinding(this.paranamer, this.getComponentImplementation(), member, i);
        Object result = currentParameter.resolveInstance(container, this, parameterType, expectedNameBinding, this.useNames(), binding);
        if (result == null && !this.isNullParamAllowed(member, i)) {
            throw new ParameterCannotBeNullException(i, member, expectedNameBinding.getName());
        }
        return result;
    }

    protected boolean isNullParamAllowed(AccessibleObject member, int i) {
        return false;
    }

    protected Annotation[] getBindings(Annotation[][] annotationss) {
        Annotation[] retVal = new Annotation[annotationss.length];
        block0: for (int i = 0; i < annotationss.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationss[i]) {
                if (annotation.annotationType().getAnnotation(Bind.class) == null) continue;
                retVal[i] = annotation;
                continue block0;
            }
        }
        return retVal;
    }

    public static class ParameterCannotBeNullException
    extends PicoCompositionException {
        private final String name;

        private ParameterCannotBeNullException(int ix, AccessibleObject member, String name) {
            super("Parameter " + ix + " of '" + member + "' named '" + name + "' cannot be null");
            this.name = name;
        }

        public String getParameterName() {
            return this.name;
        }
    }
}

