/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Injector;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.MethodInjection;
import org.picocontainer.injectors.Provider;
import org.picocontainer.injectors.Reinjector;

public class ProviderAdapter
implements Injector,
Provider {
    private final Object provider;
    private final Method provideMethod;
    private final Class key;
    private Properties properties;

    protected ProviderAdapter() {
        this.provider = this;
        this.provideMethod = ProviderAdapter.getProvideMethod(this.getClass());
        this.key = this.provideMethod.getReturnType();
        this.setUseNames(this.useNames());
    }

    public ProviderAdapter(Object provider) {
        this(provider, false);
    }

    public ProviderAdapter(Object provider, boolean useNames) {
        this.provider = provider;
        this.provideMethod = ProviderAdapter.getProvideMethod(provider.getClass());
        this.key = this.provideMethod.getReturnType();
        this.setUseNames(useNames);
    }

    private void setUseNames(boolean b) {
        this.properties = b ? Characteristics.USE_NAMES : Characteristics.NONE;
    }

    protected boolean useNames() {
        return false;
    }

    public Object decorateComponentInstance(PicoContainer container, Type into, Object instance) {
        return null;
    }

    public Object getComponentKey() {
        return this.key;
    }

    public Class getComponentImplementation() {
        return this.key;
    }

    @Deprecated
    public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        return new Reinjector(container).reinject(this.key, this.provider.getClass(), this.provider, this.properties, new MethodInjection(this.provideMethod));
    }

    public static Method getProvideMethod(Class clazz) {
        Method provideMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals("provide")) continue;
            if (provideMethod != null) {
                throw ProviderAdapter.newProviderMethodException("only one");
            }
            provideMethod = method;
        }
        if (provideMethod == null) {
            throw ProviderAdapter.newProviderMethodException("a");
        }
        if (provideMethod.getReturnType() == Void.TYPE) {
            throw ProviderAdapter.newProviderMethodException("a non void returning");
        }
        return provideMethod;
    }

    private static PicoCompositionException newProviderMethodException(String str) {
        return new PicoCompositionException("There must be " + str + " method named 'provide' in the AbstractProvider implementation");
    }

    public void verify(PicoContainer container) throws PicoCompositionException {
    }

    public void accept(PicoVisitor visitor) {
    }

    public ComponentAdapter getDelegate() {
        return null;
    }

    public ComponentAdapter findAdapterOfType(Class componentAdapterType) {
        return null;
    }

    public String getDescriptor() {
        return "AbstractProvider";
    }
}

