/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.behaviors.Stored;
import org.picocontainer.references.ThreadLocalMapObjectReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storing
extends AbstractBehaviorFactory {
    private final StoreThreadLocal mapThreadLocalObjectReference = new StoreThreadLocal();

    @Override
    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        if (Storing.removePropertiesIfPresent(componentProperties, Characteristics.NO_CACHE)) {
            return super.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        }
        Storing.removePropertiesIfPresent(componentProperties, Characteristics.CACHE);
        return componentMonitor.newBehavior(new Stored<T>(super.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters), new ThreadLocalMapObjectReference(this.mapThreadLocalObjectReference, componentKey)));
    }

    @Override
    public <T> ComponentAdapter<T> addComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, ComponentAdapter<T> adapter) {
        if (Storing.removePropertiesIfPresent(componentProperties, Characteristics.NO_CACHE)) {
            return super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter);
        }
        Storing.removePropertiesIfPresent(componentProperties, Characteristics.CACHE);
        return componentMonitor.newBehavior(new Stored<T>(super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter), new ThreadLocalMapObjectReference(this.mapThreadLocalObjectReference, adapter.getComponentKey())));
    }

    public StoreWrapper getCacheForThread() {
        StoreWrapper wrappedMap = new StoreWrapper();
        wrappedMap.wrapped = (Map)this.mapThreadLocalObjectReference.get();
        return wrappedMap;
    }

    public void putCacheForThread(StoreWrapper wrappedMap) {
        this.mapThreadLocalObjectReference.set(wrappedMap.wrapped);
    }

    public StoreWrapper resetCacheForThread() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.mapThreadLocalObjectReference.set(map);
        StoreWrapper storeWrapper = new StoreWrapper();
        storeWrapper.wrapped = map;
        return storeWrapper;
    }

    public void invalidateCacheForThread() {
        this.mapThreadLocalObjectReference.set(Collections.unmodifiableMap(Collections.emptyMap()));
    }

    public int getCacheSize() {
        return ((Map)this.mapThreadLocalObjectReference.get()).size();
    }

    public static class StoreWrapper
    implements Serializable {
        private Map wrapped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StoreThreadLocal
    extends ThreadLocal<Map>
    implements Serializable {
        @Override
        protected Map initialValue() {
            return new ConcurrentHashMap();
        }
    }
}

