/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.behaviors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenImplementation<T>
extends AbstractBehavior<T> {
    public HiddenImplementation(ComponentAdapter<T> delegate) {
        super(delegate);
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Class[] classes;
        ComponentAdapter delegate = this.getDelegate();
        Object componentKey = delegate.getComponentKey();
        if (componentKey instanceof Class && ((Class)delegate.getComponentKey()).isInterface()) {
            classes = new Class[]{(Class)delegate.getComponentKey()};
        } else if (componentKey instanceof Class[]) {
            classes = (Class[])componentKey;
        } else {
            return delegate.getComponentInstance(container, into);
        }
        this.verifyInterfacesOnly(classes);
        return this.createProxy(classes, container, delegate.getComponentImplementation().getClassLoader());
    }

    @Override
    public String getDescriptor() {
        return "Hidden";
    }

    protected T createProxy(Class[] interfaces, final PicoContainer container, ClassLoader classLoader) {
        return (T)Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){

            public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return HiddenImplementation.this.invokeMethod(HiddenImplementation.this.getDelegate().getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class)), method, args, container);
            }
        });
    }

    protected Object invokeMethod(Object componentInstance, Method method, Object[] args, PicoContainer container) throws Throwable {
        ComponentMonitor componentMonitor = this.currentMonitor();
        try {
            componentMonitor.invoking(container, this, method, componentInstance);
            long startTime = System.currentTimeMillis();
            Object object = method.invoke(componentInstance, args);
            componentMonitor.invoked(container, this, method, componentInstance, System.currentTimeMillis() - startTime);
            return object;
        }
        catch (InvocationTargetException ite) {
            componentMonitor.invocationFailed(method, componentInstance, ite);
            throw ite.getTargetException();
        }
    }

    private void verifyInterfacesOnly(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) continue;
            throw new PicoCompositionException("Class keys must be interfaces. " + clazz + " is not an interface.");
        }
    }
}

