/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoContainer;
import org.picocontainer.monitors.AbstractComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotDependencyGraphComponentMonitor
extends AbstractComponentMonitor
implements ComponentMonitor {
    final List<Instantiation> allInstantiated = new ArrayList<Instantiation>();

    public DotDependencyGraphComponentMonitor(ComponentMonitor delegate) {
        super(delegate);
    }

    public DotDependencyGraphComponentMonitor() {
    }

    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] injected, long duration) {
        this.allInstantiated.add(new Instantiation(constructor, instantiated, injected, duration));
        super.instantiated(container, componentAdapter, constructor, instantiated, injected, duration);
    }

    public String getClassDependencyGraph() {
        HashSet<String> lines = new HashSet<String>();
        Iterator<Instantiation> i$ = this.allInstantiated.iterator();
        while (i$.hasNext()) {
            Instantiation anAllInstantiated;
            Instantiation instantiation = anAllInstantiated = i$.next();
            for (int j = 0; j < instantiation.getInjected().length; ++j) {
                Object instantiated = instantiation.getInstantiated();
                Object injected = instantiation.getInjected()[j];
                lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injected.getClass().getName() + "';\n");
            }
        }
        return this.sortLines(lines);
    }

    private String sortLines(Set<String> lines) {
        ArrayList<String> list = new ArrayList<String>(lines);
        Collections.sort(list);
        String dependencies = "";
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            String aList;
            String dep = aList = (String)i$.next();
            dependencies = dependencies + dep;
        }
        return dependencies.replaceAll("'", "\"");
    }

    public String getInterfaceDependencyGraph() {
        HashSet<String> lines = new HashSet<String>();
        Iterator<Instantiation> i$ = this.allInstantiated.iterator();
        while (i$.hasNext()) {
            Instantiation anAllInstantiated;
            Instantiation instantiation = anAllInstantiated = i$.next();
            for (int j = 0; j < instantiation.getInjected().length; ++j) {
                Object injected = instantiation.getInjected()[j];
                Class<?> injectedType = instantiation.getConstructor().getParameterTypes()[j];
                Object instantiated = instantiation.getInstantiated();
                if (injected.getClass() != injectedType) {
                    lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injectedType.getName() + "' [style=dotted,label='needs'];\n");
                    lines.add("  '" + injected.getClass().getName() + "' -> '" + injectedType.getName() + "' [style=dotted, color=red,label='isA'];\n");
                    lines.add("  '" + injectedType.getName() + "' [shape=box, label=" + this.printClassName(injectedType) + "];\n");
                } else {
                    lines.add("  '" + instantiated.getClass().getName() + "' -> '" + injected.getClass().getName() + "' [label='needs'];\n");
                }
                lines.add("  '" + instantiated.getClass().getName() + "' [label=" + this.printClassName(instantiated.getClass()) + "];\n");
            }
        }
        return this.sortLines(lines);
    }

    private String printClassName(Class<?> clazz) {
        String className = clazz.getName();
        return "'" + className.substring(className.lastIndexOf(".") + 1) + "\\n" + clazz.getPackage().getName() + "'";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Instantiation {
        final Constructor<?> constructor;
        final Object instantiated;
        final Object[] injected;
        final long duration;

        public Instantiation(Constructor<?> constructor, Object instantiated, Object[] injected, long duration) {
            this.constructor = constructor;
            this.instantiated = instantiated;
            this.injected = injected;
            this.duration = duration;
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public Object getInstantiated() {
            return this.instantiated;
        }

        public Object[] getInjected() {
            return this.injected;
        }
    }
}

