/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jndi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.picocontainer.ObjectReference;
import org.picocontainer.PicoCompositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIObjectReference<T>
implements ObjectReference<T>,
Serializable {
    String name;
    transient Context context;

    public JNDIObjectReference(String name, Context ctx) {
        this.name = name;
        this.context = ctx;
    }

    public JNDIObjectReference(String jndiName) throws NamingException {
        this(jndiName, new InitialContext());
    }

    public T get() {
        try {
            return (T)this.context.lookup(this.name);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            throw new PicoCompositionException("unable to resolve jndi name:" + this.name, (Throwable)e);
        }
    }

    public void set(T item) {
        block9: {
            try {
                if (item == null) {
                    this.context.unbind(this.name);
                    break block9;
                }
                Context ctx = this.context;
                Name n = ctx.getNameParser("").parse(this.name);
                while (n.size() > 1) {
                    String ctxName = n.get(0);
                    try {
                        ctx = (Context)ctx.lookup(ctxName);
                    }
                    catch (NameNotFoundException e) {
                        ctx = ctx.createSubcontext(ctxName);
                    }
                    n = n.getSuffix(1);
                }
                try {
                    if (ctx.lookup(n) != null) {
                        ctx.unbind(n);
                    }
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
                ctx.bind(n, item);
            }
            catch (NamingException e) {
                throw new PicoCompositionException("unable to bind to  jndi name:" + this.name, (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new IOException("unable to create initial context");
        }
        in.defaultReadObject();
    }

    public String toString() {
        return "(" + this.getName() + ")";
    }
}

