/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    private Document doc;
    private XPath xpath;
    private static volatile XmlParser xmlParser;

    private XmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlParser getInstance() {
        if (xmlParser != null) return xmlParser;
        Class<XmlParser> clazz = XmlParser.class;
        synchronized (XmlParser.class) {
            if (xmlParser != null) return xmlParser;
            xmlParser = new XmlParser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlParser;
        }
    }

    public XmlParser parserXmlFile(String xmlFilePath) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(new FileInputStream(new File(xmlFilePath)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
        return XmlParser.getInstance();
    }

    public XmlParser parserXmlContent(String xmlContent) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(IOUtils.toInputStream((String)xmlContent));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
        return XmlParser.getInstance();
    }

    public int getLevels() {
        return this.doc.getDocumentElement().getChildNodes().getLength();
    }

    public List<String> getRootElements() {
        ArrayList<String> names = new ArrayList<String>();
        NodeList nodeList = this.doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            names.add(nodeList.item(i).getNodeName());
        }
        return names;
    }

    public Node getNodeElement(String xpathContent) {
        try {
            return (Node)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getRoot(String rootXpath) {
        try {
            Node node = (Node)this.xpath.evaluate(rootXpath, this.doc, XPathConstants.NODE);
            return node.getNodeValue();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getChildNames(String xpathContent) {
        try {
            ArrayList<String> nodeNames = new ArrayList<String>();
            NodeList nodeList = (NodeList)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeNames.add(nodeList.item(i).getNodeName());
            }
            return nodeNames;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getChildValues(String xpathContent) {
        try {
            ArrayList<String> nodeValues = new ArrayList<String>();
            NodeList nodeList = (NodeList)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeValues.add(nodeList.item(i).getTextContent());
            }
            return nodeValues;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> haveChildsElements(String xpathContent) {
        try {
            ArrayList<String> nodeNames = new ArrayList<String>();
            NodeList nodeList = (NodeList)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeNames.add(nodeList.item(i).getNodeName());
            }
            return nodeNames;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getNodeNameAndValues(String xpathContent) {
        ArrayList<String> nodeNameAndValues = new ArrayList<String>();
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeNameAndValues.add(nodeList.item(i).getNodeName() + "-->" + nodeList.item(i).getNodeValue());
            }
            return nodeNameAndValues;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NodeList getAttriNode(String xpathContent) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)this.xpath.evaluate(xpathContent, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return nodeList;
    }
}

