/*
 * Decompiled with CFR 0.152.
 */
package org.phoenix.api.action;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.phoenix.api.action.APIAction;
import org.phoenix.api.utils.JsonPaser;
import org.phoenix.api.utils.MyX509TrustManager;
import org.xml.sax.SAXException;

public class WebAPIAction
implements APIAction {
    @Override
    public WebConversation getWebConversation() {
        return new WebConversation();
    }

    @Override
    public WebResponse getResponseByHost(String url, String postorget, WebConversation wc) {
        return this.getResponseByHttpUnit(wc, null, 0, null, null, postorget, url, -1, -1, null, null);
    }

    @Override
    public WebResponse getResponseByPost(String url, String hostIP, int hostPort, HashMap<String, String> params, HashMap<String, String> headers) {
        return this.getResponseByHttpUnit(null, hostIP, hostPort, "", "", "post", url, -1, -1, params, headers);
    }

    @Override
    public WebResponse getResponseByHost(String url, String postorget, String hostIP, int hostPort) {
        return this.getResponseByHttpUnit(null, hostIP, hostPort, "", "", postorget, url, -1, -1, null, null);
    }

    @Override
    public WebResponse getResponseByHost(String url, String postorget, String hostIP, int hostPort, String hostName, String hostPassword) {
        return this.getResponseByHttpUnit(null, hostIP, hostPort, hostName, hostPassword, postorget, url, -1, -1, null, null);
    }

    @Override
    public WebResponse getResponseByPost(String url) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "post", url, -1, -1, null, null);
    }

    @Override
    public WebResponse getResponseByPost(String url, int connTimeOut, int readTimeout) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "post", url, connTimeOut, readTimeout, null, null);
    }

    @Override
    public WebResponse getResponseByPost(String url, HashMap<String, String> parameters, HashMap<String, String> headers) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "post", url, -1, -1, parameters, headers);
    }

    @Override
    public WebResponse getResponseByGet(String url) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "get", url, -1, -1, null, null);
    }

    @Override
    public WebResponse getResponseByGet(String url, int connTimeOut, int readTimeout) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "get", url, connTimeOut, readTimeout, null, null);
    }

    @Override
    public WebResponse getResponseByGet(String url, HashMap<String, String> parameters, HashMap<String, String> headers) {
        return this.getResponseByHttpUnit(null, null, 0, null, null, "get", url, -1, -1, parameters, headers);
    }

    @Override
    public WebResponse getResponseByHttpUnit(WebConversation webConv, String hostIP, int hostPort, String hostUser, String hostPassword, String postorget, String url, int connTimeOut, int readTimeout, HashMap<String, String> parameters, HashMap<String, String> headers) {
        GetMethodWebRequest req;
        WebConversation wc;
        WebConversation webConversation = wc = webConv == null ? new WebConversation() : webConv;
        if (connTimeOut != -1) {
            wc.set_connectTimeout(connTimeOut);
        }
        if (readTimeout != -1) {
            wc.set_readTimeout(readTimeout);
        }
        if (hostIP != null) {
            wc.setProxyServer(hostIP, hostPort, hostUser, hostPassword);
        }
        Object object = req = postorget.equalsIgnoreCase("get") ? new GetMethodWebRequest(url) : new PostMethodWebRequest(url);
        if (parameters != null) {
            for (Map.Entry<String, String> es : parameters.entrySet()) {
                req.setParameter(es.getKey(), es.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> et : headers.entrySet()) {
                req.setHeaderField(et.getKey(), et.getValue());
            }
        }
        WebResponse wr = null;
        try {
            wr = wc.getResponse((WebRequest)req);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        wr.close();
        return wr;
    }

    @Override
    public String getJSONValue(String jsonContent, String jsonPath) {
        try {
            return JsonPaser.getNodeValue(jsonContent, jsonPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getPageSourceByHttpClientWithGet(String url) {
        try {
            return IOUtils.toString((InputStream)this.getResponseByHttpClient(null, url, "get", null).getEntity().getContent());
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getPageSourceByHttpClientWithPost(String url) {
        try {
            return IOUtils.toString((InputStream)this.getResponseByHttpClient(null, url, "post", null).getEntity().getContent());
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public HttpResponse getResponseByHttpClientWithGet(String url) {
        return this.getResponseByHttpClient(null, url, "get", null);
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url) {
        return this.getResponseByHttpClient(null, url, "post", null);
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url, String rawString) {
        return this.getResponseByHttpClientWithPost(url, null, rawString);
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url, HashMap<String, String> headers, String rawString) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                request.addHeader(e.getKey(), e.getValue());
            }
        }
        HttpResponse response = null;
        try {
            request.setEntity((HttpEntity)new StringEntity(rawString));
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url, File filePath) {
        return this.getResponseByHttpClientWithPost(url, null, filePath);
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url, HashMap<String, String> headers, File filePath) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                request.addHeader(e.getKey(), e.getValue());
            }
        }
        HttpResponse response = null;
        try {
            request.setEntity((HttpEntity)new FileEntity(filePath));
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public HttpResponse getResponseByHttpClientWithPost(String url, File filePath, ContentType contentType) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        HttpResponse response = null;
        try {
            request.setEntity((HttpEntity)new FileEntity(filePath, contentType));
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public HttpClient getHttpClientWithProxy(String proxyHost, int proxyPort, String loginName, String loginPass) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(loginName, loginPass));
        HttpHost proxy = new HttpHost(proxyHost, proxyPort);
        httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        return httpClient;
    }

    @Override
    public HttpResponse getResponseByHttpClient(HttpClient hClient, String url, String method, HashMap<String, String> headers) {
        HttpClient httpClient = hClient == null ? HttpClientBuilder.create().build() : hClient;
        HttpGet request = null;
        if (method.equalsIgnoreCase("get")) {
            request = new HttpGet(url);
        } else if (method.equalsIgnoreCase("post")) {
            request = new HttpPost(url);
        }
        if (headers != null) {
            for (Map.Entry<String, String> e2 : headers.entrySet()) {
                request.setHeader(e2.getKey(), e2.getValue());
            }
        }
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public Document parseStringToDom(String html) {
        return Jsoup.parse((String)html);
    }

    @Override
    public Document parseStringToDom(URL url, int timeout) {
        try {
            return Jsoup.parse((URL)url, (int)timeout);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document parseFileToDom(File file) {
        try {
            return Jsoup.parse((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document parseFileToDom(File file, String charset) {
        try {
            return Jsoup.parse((File)file, (String)charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document parseBodyFragment(String bodyHtml) {
        return Jsoup.parseBodyFragment((String)bodyHtml);
    }

    @Override
    public Connection.Response getResponseByJsoupByGet(String url) {
        try {
            return Jsoup.connect((String)url).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Connection.Response getResponseByJsoupByPost(String url) {
        try {
            return Jsoup.connect((String)url).method(Connection.Method.POST).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Connection.Response getResponseByJsoup(String url, String method, HashMap<String, String> headers) {
        return this.getResponseByJsoup(url, method, null, null, headers, true, null);
    }

    @Override
    public Connection.Response getResponseByJsoup(String url, String method, HashMap<String, String> datas, HashMap<String, String> headers) {
        return this.getResponseByJsoup(url, method, null, datas, headers, true, null);
    }

    @Override
    public Connection.Response getResponseByJsoup(String url, String method, HashMap<String, String> cookies, HashMap<String, String> datas, HashMap<String, String> headers, boolean isFollowRedirects, String userAgent) {
        Connection conn = Jsoup.connect((String)url);
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                conn.header(e.getKey(), e.getValue());
            }
        }
        if (datas != null) {
            conn.data(datas);
        }
        if (cookies != null) {
            conn.cookies(cookies);
        }
        if (userAgent != null) {
            conn.userAgent(userAgent);
        }
        conn.followRedirects(isFollowRedirects);
        if (method.equalsIgnoreCase("GET")) {
            conn.method(Connection.Method.GET);
        } else if (method.equalsIgnoreCase("POST")) {
            conn.method(Connection.Method.POST);
        }
        try {
            return conn.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HttpsURLConnection getURLConn(String httpsUrl, MyX509TrustManager trustManager) {
        try {
            TrustManager[] tm = new TrustManager[]{trustManager};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL myURL = new URL(httpsUrl);
            HttpsURLConnection httpsConn = (HttpsURLConnection)myURL.openConnection();
            httpsConn.setSSLSocketFactory(ssf);
            return httpsConn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HttpsURLConnection getHttpsUrlResponse(String httpsUrl, String keyStoreFile, String pass) {
        return this.getURLConn(httpsUrl, new MyX509TrustManager(keyStoreFile, pass));
    }

    @Override
    public HttpsURLConnection getHttpsUrlResponse(String httpsUrl, File keyStoreFile, String pass) {
        return this.getURLConn(httpsUrl, new MyX509TrustManager(keyStoreFile, pass));
    }

    @Override
    public HttpsURLConnection getHttpsUrlResponse(String httpsUrl, URI keyStoreFileUri, String pass) {
        return this.getURLConn(httpsUrl, new MyX509TrustManager(keyStoreFileUri, pass));
    }
}

