/*
 * Decompiled with CFR 0.152.
 */
package org.patrodyne.jvnet.hyperjaxb.opt.hibernate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.cache.CacheManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.jcache.MissingCacheStrategy;
import org.hibernate.cache.jcache.internal.JCacheRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.StandardJtaPlatformResolver;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.jvnet.hyperjaxb3.ejb.util.TransactionalSql;
import org.jvnet.jaxb2_commons.reflection.util.FieldAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryUtil {
    private static Logger log = LoggerFactory.getLogger(SessionFactoryUtil.class);

    public static Map<String, Object> gatherProperties(EntityManagerFactory emf) {
        SessionFactory sf = (SessionFactory)emf.unwrap(SessionFactory.class);
        return SessionFactoryUtil.gatherProperties(sf, (Map<String, Object>)emf.getProperties());
    }

    public static Map<String, Object> gatherProperties(EntityManagerFactory emf, Map<String, Object> emfProperties) {
        SessionFactory sf = (SessionFactory)emf.unwrap(SessionFactory.class);
        return SessionFactoryUtil.gatherProperties(sf, emfProperties);
    }

    public static Map<String, Object> gatherProperties(SessionFactory sf, Map<String, Object> emfProperties) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)sf;
        SessionFactoryOptions sfo = sfi.getSessionFactoryOptions();
        StandardServiceRegistry ssr = sfo.getServiceRegistry();
        final HashMap<String, Object> etc = new HashMap<String, Object>();
        etc.put("hibernate.connection.password", sf.getProperties().get("hibernate.connection.password"));
        if (emfProperties.containsKey("javax.persistence.sharedCache.mode")) {
            etc.put("javax.persistence.sharedCache.mode", emfProperties.get("javax.persistence.sharedCache.mode"));
        } else {
            etc.put("javax.persistence.sharedCache.mode", SharedCacheMode.UNSPECIFIED);
        }
        if (emfProperties.containsKey("javax.persistence.cache.retrieveMode")) {
            etc.put("javax.persistence.cache.retrieveMode", emfProperties.get("javax.persistence.cache.retrieveMode"));
        } else {
            etc.put("javax.persistence.cache.retrieveMode", CacheModeHelper.DEFAULT_RETRIEVE_MODE);
        }
        if (emfProperties.containsKey("javax.persistence.cache.storeMode")) {
            etc.put("javax.persistence.cache.storeMode", emfProperties.get("javax.persistence.cache.storeMode"));
        } else {
            etc.put("javax.persistence.cache.storeMode", CacheModeHelper.DEFAULT_STORE_MODE);
        }
        if (emfProperties.containsKey("hibernate.jta.cacheTransactionManager")) {
            etc.put("hibernate.jta.cacheTransactionManager", emfProperties.get("hibernate.jta.cacheTransactionManager"));
        } else {
            etc.put("hibernate.jta.cacheTransactionManager", true);
        }
        if (emfProperties.containsKey("hibernate.jta.cacheUserTransaction")) {
            etc.put("hibernate.jta.cacheUserTransaction", emfProperties.get("hibernate.jta.cacheUserTransaction"));
        } else {
            etc.put("hibernate.jta.cacheUserTransaction", false);
        }
        if (emfProperties.containsKey("hibernate.transaction.jta.platform")) {
            etc.put("hibernate.transaction.jta.platform", emfProperties.get("hibernate.transaction.jta.platform"));
        } else {
            etc.put("hibernate.transaction.jta.platform", NoJtaPlatform.class.getName());
        }
        if (emfProperties.containsKey("hibernate.transaction.jta.platform_resolver")) {
            etc.put("hibernate.transaction.jta.platform_resolver", emfProperties.get("hibernate.transaction.jta.platform_resolver"));
        } else {
            etc.put("hibernate.transaction.jta.platform_resolver", StandardJtaPlatformResolver.class.getName());
        }
        if (emfProperties.containsKey("hibernate.ejb.persistenceUnitName")) {
            etc.put("hibernate.ejb.persistenceUnitName", emfProperties.get("hibernate.ejb.persistenceUnitName"));
        }
        if (!emfProperties.containsKey("javax.persistence.schema-generation-connection")) {
            etc.put("javax.persistence.schema-generation-connection", emfProperties.get("javax.persistence.jdbc.url"));
        }
        SchemaManagementToolCoordinator.ActionGrouping actionGrouping = SchemaManagementToolCoordinator.ActionGrouping.interpret(emfProperties);
        Action databaseAction = actionGrouping.getDatabaseAction();
        FieldAccessor hbm2dllAutoAccessor = new FieldAccessor(Action.class, "externalHbm2ddlName", String.class);
        String hbm2dllAutoValue = (String)hbm2dllAutoAccessor.get((Object)databaseAction);
        etc.put("hibernate.hbm2ddl.auto", hbm2dllAutoValue);
        FieldAccessor hbm2dllDatabaseActionAccessor = new FieldAccessor(Action.class, "externalJpaName", String.class);
        String hbm2dllDatabaseActionValue = (String)hbm2dllDatabaseActionAccessor.get((Object)databaseAction);
        etc.put("javax.persistence.schema-generation.database.action", hbm2dllDatabaseActionValue);
        FieldAccessor hbm2dllScriptsActionAccessor = new FieldAccessor(Action.class, "externalJpaName", String.class);
        String hbm2dllScriptsActionValue = (String)hbm2dllScriptsActionAccessor.get((Object)databaseAction);
        etc.put("javax.persistence.schema-generation.scripts.action", hbm2dllScriptsActionValue);
        if (emfProperties.containsKey("javax.persistence.schema-generation.scripts.create-target")) {
            etc.put("javax.persistence.schema-generation.scripts.create-target", emfProperties.get("javax.persistence.schema-generation.scripts.create-target"));
        }
        if (emfProperties.containsKey("javax.persistence.schema-generation.scripts.drop-target")) {
            etc.put("javax.persistence.schema-generation.scripts.drop-target", emfProperties.get("javax.persistence.schema-generation.scripts.drop-target"));
        }
        if (!emfProperties.containsKey("hibernate.query.plan_cache_max_size")) {
            etc.put("hibernate.query.plan_cache_max_size", 2048);
        }
        if (!emfProperties.containsKey("hibernate.query.plan_parameter_metadata_max_size")) {
            etc.put("hibernate.query.plan_parameter_metadata_max_size", 128);
        }
        JdbcServices jdb = (JdbcServices)ssr.getService(JdbcServices.class);
        etc.put("hibernate.default_catalog", jdb.getJdbcEnvironment().getCurrentCatalog());
        etc.put("hibernate.default_schema", jdb.getJdbcEnvironment().getCurrentSchema());
        etc.put("hibernate.dialect", jdb.getDialect());
        etc.put("hibernate.format_sql", jdb.getSqlStatementLogger().isFormat());
        etc.put("hibernate.show_sql", jdb.getSqlStatementLogger().isLogToStdout());
        try (Session session = sf.openSession();){
            session.doWork(new Work(){

                public void execute(Connection conn) throws SQLException {
                    if (!conn.isValid(5)) {
                        log.warn("Connection may not support JDBC4!");
                    }
                    DatabaseMetaData meta = conn.getMetaData();
                    etc.put("hibernate.connection.url", meta.getURL());
                    etc.put("hibernate.connection.driver_class", DriverManager.getDriver(meta.getURL()).getClass().getName());
                    etc.put("hibernate.connection.username", meta.getUserName());
                    etc.put("hibernate.connection.isolation", meta.getDefaultTransactionIsolation());
                    etc.put("hibernate.connection.autocommit", conn.getAutoCommit());
                    switch (meta.getDefaultTransactionIsolation()) {
                        case 0: {
                            etc.put("hibernate.connection.isolation", "NONE");
                            break;
                        }
                        case 1: {
                            etc.put("hibernate.connection.isolation", "READ_UNCOMMITTED");
                            break;
                        }
                        case 2: {
                            etc.put("hibernate.connection.isolation", "READ_COMMITTED");
                            break;
                        }
                        case 4: {
                            etc.put("hibernate.connection.isolation", "REPEATABLE_READ");
                            break;
                        }
                        case 8: {
                            etc.put("hibernate.connection.isolation", "SERIALIZABLE");
                        }
                    }
                    try (Statement stmt = conn.createStatement();){
                        etc.put("hibernate.jdbc.fetch_size", stmt.getFetchSize());
                    }
                }
            });
        }
        RegionFactory crf = (RegionFactory)ssr.getService(RegionFactory.class);
        etc.put("hibernate.cache.region.factory_class", crf.getClass().getName());
        etc.put("hibernate.cache.default_cache_concurrency_strategy", crf.getDefaultAccessType().name());
        if (crf instanceof JCacheRegionFactory) {
            FieldAccessor cacheManagerAccessor = new FieldAccessor(JCacheRegionFactory.class, "cacheManager", CacheManager.class);
            CacheManager cacheManagerValue = (CacheManager)cacheManagerAccessor.get((Object)crf);
            etc.put("hibernate.javax.cache.provider", cacheManagerValue.getCachingProvider().getClass().getName());
            etc.put("hibernate.javax.cache.uri", cacheManagerValue.getURI());
            Object mcs = emfProperties.get("hibernate.javax.cache.missing_cache_strategy");
            etc.put("hibernate.javax.cache.missing_cache_strategy", MissingCacheStrategy.interpretSetting((Object)mcs));
        }
        TreeMap<String, Object> hcoMap = new TreeMap<String, Object>();
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.allowTransactionAccess", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.allowTransactionAccess", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.allowTransactionAccess", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.allow_update_outside_transaction", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.transaction.auto_close_session", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.autocommit", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.auto_evict_collection_cache", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.batch_fetch_style", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.batch_versioned_data", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.region.factory_class", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.region_prefix", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.check_nullability", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.handling_mode", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.entity_dirtiness_strategy", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.default_batch_fetch_size", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.default_cache_concurrency_strategy", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.default_catalog", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.default_entity_mode", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.default_schema", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.dialect", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.driver_class", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.format_sql", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.show_sql", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.transaction.flush_before_completion", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.generate_statistics", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.hbm2ddl.auto", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.schema-generation-connection", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.schema-generation.database.action", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.schema-generation.scripts.action", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.schema-generation.scripts.create-target", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.schema-generation.scripts.drop-target", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.hql.bulk_id_strategy", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.session_factory.interceptor", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.isolation", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.sharedCache.mode", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.cache.retrieveMode", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.cache.storeMode", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.jtaDataSource", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "javax.persistence.nonJtaDataSource", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.cacheTransactionManager", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.cacheUserTransaction", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.transaction.jta.platform", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.transaction.jta.platform_resolver", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.query.jpaql_strict_compliance", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.track_by_thread", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.max_fetch_depth", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.tenant_identifier_resolver", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.order_inserts", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.order_updates", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.password", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.ejb.persistenceUnitName", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jta.prefer_user_transaction", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.query_cache_factory", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.query.startup_check", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.query.substitutions", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.session_factory_name", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.session_factory_name_is_jndi", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.session_factory.session_scoped_interceptor", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.batch_size", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.fetch_size", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.session_factory.statement_inspector", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.url", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.use_reference_entries", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.use_get_generated_keys", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.use_identifier_rollback", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.use_minimal_puts", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.use_query_cache", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.use_scrollable_resultset", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.use_second_level_cache", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.use_sql_comments", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.cache.use_structured_entries", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.connection.username", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.jdbc.wrap_result_sets", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.javax.cache.provider", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.javax.cache.uri", etc);
        SessionFactoryUtil.putSetting(hcoMap, sf, "hibernate.javax.cache.missing_cache_strategy", etc);
        ConnectionProvider cnp = (ConnectionProvider)ssr.getService(ConnectionProvider.class);
        hcoMap.put("hibernate.connection.provider_class", cnp.getClass().getName());
        if (cnp instanceof DriverManagerConnectionProviderImpl) {
            if (!emfProperties.containsKey("hibernate.connection.initial_pool_size")) {
                hcoMap.put("hibernate.connection.initial_pool_size", 1);
            }
            if (!emfProperties.containsKey("hibernate.connection.min_pool_size")) {
                hcoMap.put("hibernate.connection.min_pool_size", 1);
            }
            if (!emfProperties.containsKey("hibernate.connection.pool_validation_interval")) {
                hcoMap.put("hibernate.connection.pool_validation_interval", 30);
            }
            if (!emfProperties.containsKey("hibernate.connection.pool_size")) {
                hcoMap.put("hibernate.connection.pool_size", 20);
            }
        }
        return hcoMap;
    }

    private static void putSetting(Map<String, Object> map, SessionFactory sf, String option, Map<String, Object> etc) {
        map.put(option, SessionFactoryUtil.settingValue(sf, option, etc));
    }

    private static Object settingValue(SessionFactory sf, String name, Map<String, Object> etc) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)sf;
        SessionFactoryOptions sfo = sfi.getSessionFactoryOptions();
        return SessionFactoryUtil.settingValue(sfo, etc, name);
    }

    private static Object settingValue(SessionFactoryOptions sfo, Map<String, Object> etc, String name) {
        Object value = "";
        switch (name) {
            case "hibernate.jta.allowTransactionAccess": {
                value = sfo.isJtaTransactionAccessEnabled();
                break;
            }
            case "hibernate.allow_update_outside_transaction": {
                value = sfo.isAllowOutOfTransactionUpdateOperations();
                break;
            }
            case "hibernate.transaction.auto_close_session": {
                value = sfo.isAutoCloseSessionEnabled();
                break;
            }
            case "hibernate.connection.autocommit": {
                value = etc.get("hibernate.connection.autocommit");
                break;
            }
            case "hibernate.cache.auto_evict_collection_cache": {
                value = sfo.isAutoEvictCollectionCache();
                break;
            }
            case "hibernate.batch_fetch_style": {
                value = sfo.getBatchFetchStyle();
                break;
            }
            case "hibernate.jdbc.batch_versioned_data": {
                value = sfo.isJdbcBatchVersionedData();
                break;
            }
            case "hibernate.cache.region.factory_class": {
                value = etc.get("hibernate.cache.region.factory_class");
                break;
            }
            case "hibernate.cache.region_prefix": {
                value = sfo.getCacheRegionPrefix();
                break;
            }
            case "hibernate.check_nullability": {
                value = sfo.isCheckNullability();
                break;
            }
            case "hibernate.connection.handling_mode": {
                value = sfo.getPhysicalConnectionHandlingMode();
                break;
            }
            case "hibernate.entity_dirtiness_strategy": {
                value = sfo.getCustomEntityDirtinessStrategy().getClass().getName();
                break;
            }
            case "hibernate.default_batch_fetch_size": {
                value = sfo.getDefaultBatchFetchSize();
                break;
            }
            case "hibernate.cache.default_cache_concurrency_strategy": {
                value = etc.get("hibernate.cache.default_cache_concurrency_strategy");
                break;
            }
            case "hibernate.default_catalog": {
                value = etc.get("hibernate.default_catalog");
                break;
            }
            case "hibernate.default_entity_mode": {
                value = sfo.getDefaultEntityMode();
                break;
            }
            case "hibernate.default_schema": {
                value = etc.get("hibernate.default_schema");
                break;
            }
            case "hibernate.dialect": {
                value = etc.get("hibernate.dialect");
                break;
            }
            case "hibernate.connection.driver_class": {
                value = etc.get("hibernate.connection.driver_class");
                break;
            }
            case "hibernate.format_sql": {
                value = etc.get("hibernate.format_sql");
                break;
            }
            case "hibernate.transaction.flush_before_completion": {
                value = sfo.isFlushBeforeCompletionEnabled();
                break;
            }
            case "hibernate.generate_statistics": {
                value = sfo.isStatisticsEnabled();
                break;
            }
            case "hibernate.hbm2ddl.auto": {
                value = etc.get("hibernate.hbm2ddl.auto");
                break;
            }
            case "javax.persistence.schema-generation-connection": {
                value = etc.get("javax.persistence.schema-generation-connection");
                break;
            }
            case "javax.persistence.schema-generation.database.action": {
                value = etc.get("javax.persistence.schema-generation.database.action");
                break;
            }
            case "javax.persistence.schema-generation.scripts.action": {
                value = etc.get("javax.persistence.schema-generation.scripts.action");
                break;
            }
            case "javax.persistence.schema-generation.scripts.create-target": {
                value = etc.get("javax.persistence.schema-generation.scripts.create-target");
                break;
            }
            case "javax.persistence.schema-generation.scripts.drop-target": {
                value = etc.get("javax.persistence.schema-generation.scripts.drop-target");
                break;
            }
            case "hibernate.hql.bulk_id_strategy": {
                value = sfo.getMultiTableBulkIdStrategy().getClass().getName();
                break;
            }
            case "hibernate.session_factory.interceptor": {
                value = sfo.getInterceptor().getClass().getName();
                break;
            }
            case "hibernate.connection.isolation": {
                value = etc.get("hibernate.connection.isolation");
                break;
            }
            case "javax.persistence.sharedCache.mode": {
                value = etc.get("javax.persistence.sharedCache.mode");
                break;
            }
            case "javax.persistence.cache.retrieveMode": {
                value = etc.get("javax.persistence.cache.retrieveMode");
                break;
            }
            case "javax.persistence.cache.storeMode": {
                value = etc.get("javax.persistence.cache.storeMode");
                break;
            }
            case "javax.persistence.jtaDataSource": {
                value = null;
                break;
            }
            case "javax.persistence.nonJtaDataSource": {
                value = null;
                break;
            }
            case "hibernate.jta.cacheTransactionManager": {
                value = etc.get("hibernate.jta.cacheTransactionManager");
                break;
            }
            case "hibernate.jta.cacheUserTransaction": {
                value = etc.get("hibernate.jta.cacheUserTransaction");
                break;
            }
            case "hibernate.transaction.jta.platform": {
                value = etc.get("hibernate.transaction.jta.platform");
                break;
            }
            case "hibernate.transaction.jta.platform_resolver": {
                value = etc.get("hibernate.transaction.jta.platform_resolver");
                break;
            }
            case "hibernate.jta.track_by_thread": {
                value = sfo.isJtaTrackByThread();
                break;
            }
            case "hibernate.max_fetch_depth": {
                value = sfo.getMaximumFetchDepth();
                break;
            }
            case "hibernate.tenant_identifier_resolver": {
                value = sfo.getCurrentTenantIdentifierResolver();
                break;
            }
            case "hibernate.order_inserts": {
                value = sfo.isOrderInsertsEnabled();
                break;
            }
            case "hibernate.order_updates": {
                value = sfo.isOrderUpdatesEnabled();
                break;
            }
            case "hibernate.connection.password": {
                value = etc.get("hibernate.connection.password");
                break;
            }
            case "hibernate.ejb.persistenceUnitName": {
                value = etc.get("hibernate.ejb.persistenceUnitName");
                break;
            }
            case "hibernate.jta.prefer_user_transaction": {
                value = sfo.isPreferUserTransaction();
                break;
            }
            case "hibernate.cache.query_cache_factory": {
                value = sfo.getTimestampsCacheFactory().getClass().getName();
                break;
            }
            case "hibernate.query.startup_check": {
                value = sfo.isNamedQueryStartupCheckingEnabled();
                break;
            }
            case "hibernate.query.substitutions": {
                value = sfo.getQuerySubstitutions();
                break;
            }
            case "hibernate.session_factory_name": {
                value = sfo.getSessionFactoryName();
                break;
            }
            case "hibernate.session_factory_name_is_jndi": {
                value = sfo.isSessionFactoryNameAlsoJndiName();
                break;
            }
            case "hibernate.session_factory.session_scoped_interceptor": {
                value = sfo.getStatelessInterceptorImplementorSupplier();
                break;
            }
            case "hibernate.show_sql": {
                value = etc.get("hibernate.show_sql");
                break;
            }
            case "hibernate.jdbc.batch_size": {
                value = sfo.getJdbcBatchSize();
                break;
            }
            case "hibernate.jdbc.fetch_size": {
                value = etc.get("hibernate.jdbc.fetch_size");
                break;
            }
            case "hibernate.session_factory.statement_inspector": {
                value = sfo.getStatementInspector();
                break;
            }
            case "hibernate.connection.url": {
                value = etc.get("hibernate.connection.url");
                break;
            }
            case "hibernate.cache.use_reference_entries": {
                value = sfo.isDirectReferenceCacheEntriesEnabled();
                break;
            }
            case "hibernate.jdbc.use_get_generated_keys": {
                value = sfo.isGetGeneratedKeysEnabled();
                break;
            }
            case "hibernate.use_identifier_rollback": {
                value = sfo.isIdentifierRollbackEnabled();
                break;
            }
            case "hibernate.cache.use_minimal_puts": {
                value = sfo.isMinimalPutsEnabled();
                break;
            }
            case "hibernate.cache.use_query_cache": {
                value = sfo.isQueryCacheEnabled();
                break;
            }
            case "hibernate.jdbc.use_scrollable_resultset": {
                value = sfo.isScrollableResultSetsEnabled();
                break;
            }
            case "hibernate.cache.use_second_level_cache": {
                value = sfo.isSecondLevelCacheEnabled();
                break;
            }
            case "hibernate.use_sql_comments": {
                value = sfo.isCommentsEnabled();
                break;
            }
            case "hibernate.cache.use_structured_entries": {
                value = sfo.isStructuredCacheEntriesEnabled();
                break;
            }
            case "hibernate.connection.username": {
                value = etc.get("hibernate.connection.username");
                break;
            }
            case "hibernate.jdbc.wrap_result_sets": {
                value = sfo.isWrapResultSetsEnabled();
                break;
            }
            case "hibernate.javax.cache.provider": {
                value = etc.get("hibernate.javax.cache.provider");
                break;
            }
            case "hibernate.javax.cache.uri": {
                value = etc.get("hibernate.javax.cache.uri");
                break;
            }
            case "hibernate.javax.cache.missing_cache_strategy": {
                value = etc.get("hibernate.javax.cache.missing_cache_strategy");
            }
        }
        return value;
    }

    public static boolean isInitialized(Object proxy) {
        return Hibernate.isInitialized((Object)proxy);
    }

    public static boolean isProxy(Object entity) {
        return entity instanceof HibernateProxy;
    }

    public static boolean logSummaryStatistics(EntityManagerFactory emf) {
        SessionFactory sessionFactory = (SessionFactory)emf.unwrap(SessionFactory.class);
        Statistics stats = sessionFactory.getStatistics();
        stats.logSummary();
        return stats.isStatisticsEnabled();
    }

    public static int sqlAction(EntityManagerFactory emf, String sqlAction) {
        SessionFactory sessionFactory = (SessionFactory)emf.unwrap(SessionFactory.class);
        return SessionFactoryUtil.sqlAction(sessionFactory, sqlAction);
    }

    public static int sqlAction(SessionFactory sf, String sqlAction) {
        try (Session session = sf.openSession();){
            ReturningWork rw = connection -> {
                TransactionalSql tx = conn -> {
                    Statement stmt = conn.createStatement();
                    return stmt.executeUpdate(sqlAction);
                };
                return (Integer)tx.transact(connection);
            };
            int n = (Integer)session.doReturningWork(rw);
            return n;
        }
    }

    public static int[] sqlBatch(EntityManagerFactory emf, List<String> sqlBatch) {
        SessionFactory sessionFactory = (SessionFactory)emf.unwrap(SessionFactory.class);
        return SessionFactoryUtil.sqlBatch(sessionFactory, sqlBatch);
    }

    public static int[] sqlBatch(SessionFactory sf, List<String> sqlBatch) {
        try (Session session = sf.openSession();){
            ReturningWork rw = connection -> {
                TransactionalSql tx = conn -> {
                    Statement stmt = conn.createStatement();
                    for (String sql : sqlBatch) {
                        stmt.addBatch(sql);
                    }
                    return stmt.executeBatch();
                };
                return (int[])tx.transact(connection);
            };
            int[] nArray = (int[])session.doReturningWork(rw);
            return nArray;
        }
    }

    public static Map<String, List<Object>> sqlQuery(EntityManagerFactory emf, String sql) {
        SessionFactory sessionFactory = (SessionFactory)emf.unwrap(SessionFactory.class);
        return SessionFactoryUtil.sqlQuery(sessionFactory, sql);
    }

    public static Map<String, List<Object>> sqlQuery(SessionFactory sf, String sql) {
        try (Session session = sf.openSession();){
            ReturningWork rw = connection -> {
                TransactionalSql tx = conn -> {
                    Statement stmt = conn.createStatement();
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        Map<String, List<Object>> map = SessionFactoryUtil.toColumnMap(rs);
                        return map;
                    }
                };
                return (Map)tx.transact(connection);
            };
            Map map = (Map)session.doReturningWork(rw);
            return map;
        }
    }

    private static Map<String, List<Object>> toColumnMap(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        HashMap<String, List<Object>> columnMap = new HashMap<String, List<Object>>(columns);
        for (int index = 1; index <= columns; ++index) {
            columnMap.put(md.getColumnName(index), new ArrayList());
        }
        while (rs.next()) {
            for (int i = 1; i <= columns; ++i) {
                ((List)columnMap.get(md.getColumnName(i))).add(rs.getObject(i));
            }
        }
        return columnMap;
    }
}

