/*
 * Decompiled with CFR 0.152.
 */
package org.parttio.vaadinjsloader;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import java.util.HashMap;
import java.util.Map;

public class JSLoader {
    public static final String CDNJS = "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}";
    public static final String CDNJS_MIN = "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}";
    public static final String URL_PATTERN_UNPKGCOM = "https://unpkg.com/{library}@{version}";
    public static final String URL_PATTERN_UNPKGCOM_FILES = "https://unpkg.com/{library}@{version}/{file}";

    public static void load(Component component, String libraryName, String version, String libraryFile, String urlPattern) {
        JSLoader.loadFiles(component, urlPattern, libraryName, version, libraryFile);
    }

    public static void loadFiles(Component component, String urlPattern, String libraryName, String version, String ... file) {
        assert (component != null) : "Component cannot be null";
        assert (libraryName != null && !libraryName.isEmpty()) : "Library name cannot be null or empty";
        assert (urlPattern != null && !urlPattern.isEmpty()) : "URL Pattern cannot be null or empty";
        if (version == null || version.isEmpty()) {
            version = "latest";
        }
        if (JSLoader.isLoaded(component, libraryName)) {
            return;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("library", libraryName);
        replacements.put("version", version);
        UI ui = JSLoader.getUI(component);
        if (file != null && file.length > 0) {
            for (String f : file) {
                replacements.put("file", f);
                String fileUrl = JSLoader.replacePlaceholders(urlPattern, replacements);
                if (f.toLowerCase().endsWith(".css")) {
                    ui.getPage().addStyleSheet(fileUrl);
                    continue;
                }
                ui.getPage().addJavaScript(fileUrl);
            }
        } else {
            String scriptUrl = JSLoader.replacePlaceholders(urlPattern, replacements);
            ui.getPage().addJavaScript(scriptUrl);
        }
        JSLoader.setLoadedVersion(ui, libraryName, version);
    }

    public static String getLoadedVersion(Component component, String library) {
        String propertyKey = "loaded-" + library;
        return JSLoader.getUI(component).getElement().getProperty(propertyKey);
    }

    public static void loadCdnjs(Component component, String libraryName, String version) {
        JSLoader.load(component, libraryName, version, libraryName + ".min.js", "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
    }

    public static void loadCdnjs(Component component, String libraryName, String version, boolean minified) {
        if (minified) {
            JSLoader.load(component, libraryName, version, null, "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
        } else {
            JSLoader.load(component, libraryName, version, null, "https://cdnjs.cloudflare.com/ajax/libs/{library}/{version}/{file}");
        }
    }

    public static void loadUnpkg(Component component, String libraryName, String version, String ... libraryFile) {
        if (libraryFile != null && libraryFile.length > 0) {
            JSLoader.loadFiles(component, URL_PATTERN_UNPKGCOM_FILES, libraryName, version, libraryFile);
        } else {
            JSLoader.loadFiles(component, URL_PATTERN_UNPKGCOM, libraryName, version, libraryFile);
        }
    }

    private static String replacePlaceholders(String baseUrlPattern, Map<String, String> replacements) {
        String result = baseUrlPattern;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            if (entry.getValue() == null) continue;
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private static UI getUI(Component component) {
        if (component instanceof UI) {
            return (UI)component;
        }
        return component.getUI().orElse(UI.getCurrent());
    }

    private static void setLoadedVersion(UI ui, String library, String version) {
        String propertyKey = "loaded-" + library;
        ui.getElement().setProperty(propertyKey, version);
    }

    public static boolean isLoaded(Component component, String library) {
        return JSLoader.getLoadedVersion(component, library) != null;
    }

    public static boolean isLoaded(Component component, String library, String version) {
        return version != null && version.equals(JSLoader.getLoadedVersion(component, library));
    }
}

