/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc;

import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.pantsbuild.zinc.Util;
import sbt.FileFilter;
import sbt.FileFilter$;
import sbt.Hash$;
import sbt.IO$;
import sbt.Path$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.package$;
import scala.util.matching.Regex;

public final class Util$ {
    public static final Util$ MODULE$;
    private final Regex Duration;

    static {
        new Util$();
    }

    public String timing(long start) {
        long end = System.currentTimeMillis();
        return new StringOps(Predef$.MODULE$.augmentString("at %s [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dateTime(end), this.duration(end - start)}));
    }

    public String duration(long millis) {
        long secs = millis / 1000L;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)(secs / 60L)), (Object)BoxesRunTime.boxToLong((long)(secs % 60L)), (Object)BoxesRunTime.boxToLong((long)(millis % 1000L)));
        if (tuple3 != null) {
            Tuple3 tuple32;
            long m = BoxesRunTime.unboxToLong((Object)tuple3._1());
            long s = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long ms = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)m), (Object)BoxesRunTime.boxToLong((long)s), (Object)BoxesRunTime.boxToLong((long)ms));
            long m2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
            long s2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
            long ms2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            return m2 > 0L ? new StringOps(Predef$.MODULE$.augmentString("%d:%02d.%03ds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m2), BoxesRunTime.boxToLong((long)s2), BoxesRunTime.boxToLong((long)ms2)})) : new StringOps(Predef$.MODULE$.augmentString("%d.%03ds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)s2), BoxesRunTime.boxToLong((long)ms2)}));
        }
        throw new MatchError((Object)tuple3);
    }

    public String dateTime(long time) {
        return DateFormat.getDateTimeInstance().format(new Date(time));
    }

    public File normalise(Option<File> cwd, File file) {
        return cwd.isDefined() && !file.isAbsolute() ? new File((File)cwd.get(), file.getPath()) : file;
    }

    public Option<File> normaliseOpt(Option<File> cwd, Option<File> optFile) {
        return cwd.isDefined() ? optFile.map((Function1)new Serializable(cwd){
            public static final long serialVersionUID = 0L;
            private final Option cwd$2;

            public final File apply(File file) {
                return Util$.MODULE$.normalise((Option<File>)this.cwd$2, file);
            }
            {
                this.cwd$2 = cwd$2;
            }
        }) : optFile;
    }

    public Tuple2<File, File> normalisePair(Option<File> cwd, Tuple2<File, File> pair) {
        return cwd.isDefined() ? new Tuple2((Object)this.normalise(cwd, (File)pair._1()), (Object)this.normalise(cwd, (File)pair._2())) : pair;
    }

    public Seq<File> normaliseSeq(Option<File> cwd, Seq<File> files) {
        return cwd.isDefined() ? (Seq)files.map((Function1)new Serializable(cwd){
            public static final long serialVersionUID = 0L;
            private final Option cwd$1;

            public final File apply(File file) {
                return Util$.MODULE$.normalise((Option<File>)this.cwd$1, file);
            }
            {
                this.cwd$1 = cwd$1;
            }
        }, Seq$.MODULE$.canBuildFrom()) : files;
    }

    public Map<File, File> normaliseMap(Option<File> cwd, Map<File, File> mapped) {
        return cwd.isDefined() ? (Map)mapped.map((Function1)new Serializable(cwd){
            public static final long serialVersionUID = 0L;
            private final Option cwd$3;

            public final Tuple2<File, File> apply(Tuple2<File, File> x0$1) {
                Tuple2<File, File> tuple2 = x0$1;
                if (tuple2 != null) {
                    File l = (File)tuple2._1();
                    File r = (File)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)Util$.MODULE$.normalise((Option<File>)this.cwd$3, l), (Object)Util$.MODULE$.normalise((Option<File>)this.cwd$3, r));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.cwd$3 = cwd$3;
            }
        }, Map$.MODULE$.canBuildFrom()) : mapped;
    }

    public Map<Seq<File>, File> normaliseSeqMap(Option<File> cwd, Map<Seq<File>, File> mapped) {
        return cwd.isDefined() ? (Map)mapped.map((Function1)new Serializable(cwd){
            public static final long serialVersionUID = 0L;
            private final Option cwd$4;

            public final Tuple2<Seq<File>, File> apply(Tuple2<Seq<File>, File> x0$2) {
                Tuple2<Seq<File>, File> tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq l = (Seq)tuple2._1();
                    File r = (File)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(Util$.MODULE$.normaliseSeq((Option<File>)this.cwd$4, (Seq<File>)l), (Object)Util$.MODULE$.normalise((Option<File>)this.cwd$4, r));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.cwd$4 = cwd$4;
            }
        }, Map$.MODULE$.canBuildFrom()) : mapped;
    }

    public String relativize(File base, File path) {
        return package$.MODULE$.Path().jfile2path(base).relativize(package$.MODULE$.Path().jfile2path(path)).toString();
    }

    public boolean checkWritable(File file) {
        boolean bl;
        try {
            IO$.MODULE$.touch(file, IO$.MODULE$.touch$default$2());
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void cleanAllClasses(File dir) {
        IO$.MODULE$.delete((Iterable)Path$.MODULE$.singleFileFinder(dir).$times$times((FileFilter)FileFilter$.MODULE$.globFilter("*.class")).get());
    }

    public String pathHash(File file) {
        return Hash$.MODULE$.toHex(Hash$.MODULE$.apply(file.getCanonicalPath()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int intProperty(String name, int n) {
        int n2;
        String value = System.getProperty(name);
        if (value == null) {
            n2 = n;
            return n2;
        }
        try {
            n2 = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
            return n2;
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    public Set<String> stringSetProperty(String name, Set<String> set2) {
        String value = System.getProperty(name);
        return value != null ? Predef$.MODULE$.refArrayOps((Object[])value.split(",")).toSet() : set2;
    }

    public File fileProperty(String name) {
        return new File(System.getProperty(name, ""));
    }

    public Option<File> optFileProperty(String name) {
        return Option$.MODULE$.apply((Object)System.getProperty(name, null)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        });
    }

    public Option<String> propertyFromResource(String resource, String property, ClassLoader classLoader) {
        Properties props = this.propertiesFromResource(resource, classLoader);
        return Option$.MODULE$.apply((Object)props.getProperty(property));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propertiesFromResource(String resource, ClassLoader classLoader) {
        void var3_3;
        Properties props = new Properties();
        InputStream stream = classLoader.getResourceAsStream(resource);
        try {
            props.load(stream);
        }
        catch (Exception exception) {
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return var3_3;
    }

    public void setProperties(Seq<String> props) {
        props.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(String prop) {
                String[] kv = prop.split("=");
                return kv.length == 2 ? System.setProperty(kv[0], kv[1]) : BoxedUnit.UNIT;
            }
        });
    }

    public Regex Duration() {
        return this.Duration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long duration(String arg, long l) {
        long l2;
        int n;
        String unit;
        String string2;
        String string = arg;
        Option option = this.Duration().unapplySeq((Object)string);
        if (option.isEmpty()) return l;
        if (option.get() == null) return l;
        if (((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) return l;
        String length = (String)((LinearSeqOptimized)option.get()).apply(0);
        String string3 = string2 = (unit = (String)((LinearSeqOptimized)option.get()).apply(1));
        if (!("h" != null ? !"h".equals(string3) : string3 != null)) {
            n = 3600000;
        } else {
            String string4 = string2;
            if (!("m" != null ? !"m".equals(string4) : string4 != null)) {
                n = 60000;
            } else {
                String string5 = string2;
                n = !("s" != null ? !"s".equals(string5) : string5 != null) ? 1000 : 0;
            }
        }
        int multiplier = n;
        try {
            l2 = new StringOps(Predef$.MODULE$.augmentString(length)).toLong() * (long)multiplier;
            return l2;
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    public Util.Alarm timer(long delay, Function0<BoxedUnit> body) {
        return new Util.Alarm(delay, body);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show(Object thing, Function1<String, BoxedUnit> output, String prefix, int level) {
        Object object;
        Traversable traversable;
        boolean bl;
        while (true) {
            Object object2;
            Some some;
            Object value;
            bl = false;
            traversable = null;
            object = thing;
            if (object instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)object;
                Object label = tuple2._1();
                Object value2 = tuple2._2();
                if (label instanceof Object) {
                    Object object3 = label;
                    if (value2 instanceof Object) {
                        Object object4 = value2;
                        prefix = new StringBuilder().append((Object)object3.toString()).append((Object)" = ").toString();
                        thing = object4;
                        continue;
                    }
                }
            }
            if (!(object instanceof Some) || !((value = (some = (Some)object).x()) instanceof Object)) break;
            thing = object2 = value;
        }
        None$ none$ = None$.MODULE$;
        Object object5 = object;
        if (!(none$ != null ? !none$.equals(object5) : object5 != null)) {
            this.out$1(prefix, output, level);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (object instanceof Traversable) {
            bl = true;
            traversable = (Traversable)object;
            if (traversable.isEmpty()) {
                this.out$1(new StringBuilder().append((Object)prefix).append((Object)"{}").toString(), output, level);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            this.out$1(new StringBuilder().append((Object)prefix).append((Object)"{").toString(), output, level);
            traversable.foreach((Function1)new Serializable(output, level){
                public static final long serialVersionUID = 0L;
                private final Function1 output$1;
                private final int level$1;

                public final void apply(Object a) {
                    Util$.MODULE$.show(a, (Function1<String, BoxedUnit>)this.output$1, "", this.level$1 + 1);
                }
                {
                    this.output$1 = output$1;
                    this.level$1 = level$1;
                }
            });
            this.out$1("}", output, level);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.out$1(new StringBuilder().append((Object)prefix).append((Object)object.toString()).toString(), output, level);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public String show$default$3() {
        return "";
    }

    public int show$default$4() {
        return 0;
    }

    public String counted(int count, String prefix, String single, String plural) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)count)).toString()).append((Object)" ").append((Object)prefix).append((Object)(count == 1 ? single : plural)).toString();
    }

    private final void out$1(String s, Function1 output$1, int level$1) {
        output$1.apply((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("   ")).$times(level$1)).append((Object)s).toString());
    }

    private Util$() {
        MODULE$ = this;
        this.Duration = new StringOps(Predef$.MODULE$.augmentString("(\\d+)([hms])")).r();
    }
}

