/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc;

import java.io.File;
import org.pantsbuild.zinc.Compiler;
import org.pantsbuild.zinc.Compiler$;
import org.pantsbuild.zinc.Inputs;
import org.pantsbuild.zinc.Inputs$;
import org.pantsbuild.zinc.Parsed;
import org.pantsbuild.zinc.Settings;
import org.pantsbuild.zinc.Settings$;
import org.pantsbuild.zinc.Setup;
import org.pantsbuild.zinc.Setup$;
import org.pantsbuild.zinc.Util$;
import org.pantsbuild.zinc.logging.Loggers$;
import sbt.ConsoleOut;
import sbt.Level$;
import sbt.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.matching.Regex;
import xsbti.CompileFailed;

public final class Main$ {
    public static final Main$ MODULE$;

    static {
        new Main$();
    }

    public void main(String[] args) {
        this.run(args, (Option<File>)None$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String[] args, Option<File> cwd) {
        Object object;
        boolean isDebug;
        Tuple3 tuple3;
        long startTime = System.currentTimeMillis();
        Parsed<Settings> parsed = Settings$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (parsed == null) throw new MatchError(parsed);
        Settings rawSettings = parsed.context();
        Seq<String> residual = parsed.remaining();
        Seq<String> errors = parsed.errors();
        Tuple3 tuple32 = tuple3 = new Tuple3((Object)rawSettings, residual, errors);
        Settings rawSettings2 = (Settings)tuple32._1();
        Seq residual2 = (Seq)tuple32._2();
        Seq errors2 = (Seq)tuple32._3();
        Settings settings = Settings$.MODULE$.normalise(rawSettings2, cwd);
        if (cwd.isDefined()) {
            Util$.MODULE$.setProperties(settings.properties());
        }
        Enumeration.Value x$3 = settings.consoleLog().logLevel();
        boolean x$4 = settings.consoleLog().color();
        Seq<Regex> x$5 = settings.consoleLog().logFilters();
        Option<File> x$6 = settings.captureLog();
        ConsoleOut x$7 = Loggers$.MODULE$.create$default$4();
        Logger log = Loggers$.MODULE$.create(x$3, x$4, x$5, x$7, x$6);
        Enumeration.Value value = settings.consoleLog().logLevel();
        Enumeration.Value value2 = Level$.MODULE$.Debug();
        boolean bl = !(value != null ? !value.equals(value2) : value2 != null) ? true : (isDebug = false);
        if (errors2.nonEmpty()) {
            errors2.foreach((Function1)new Serializable(log){
                public static final long serialVersionUID = 0L;
                private final Logger log$1;

                public final void apply(String error) {
                    this.log$1.error((Function0)new Serializable(this, error){
                        public static final long serialVersionUID = 0L;
                        private final String error$1;

                        public final String apply() {
                            return this.error$1;
                        }
                        {
                            this.error$1 = error$1;
                        }
                    });
                }
                {
                    this.log$1 = log$1;
                }
            });
            log.error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("See %s -help for information about options")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Setup$.MODULE$.Command()}));
                }
            });
            throw package$.MODULE$.exit(1);
        }
        if (settings.version()) {
            Setup$.MODULE$.printVersion();
        }
        if (settings.help()) {
            Settings$.MODULE$.printUsage();
        }
        Inputs inputs2 = Inputs$.MODULE$.apply(log, settings);
        Setup setup = Setup$.MODULE$.apply(settings);
        if (inputs2.sources().isEmpty()) {
            if (settings.version()) throw package$.MODULE$.exit(0);
            if (settings.help()) {
                throw package$.MODULE$.exit(0);
            }
            Setup$.MODULE$.printVersion();
            Settings$.MODULE$.printUsage();
            throw package$.MODULE$.exit(1);
        }
        if (!Setup$.MODULE$.verify(setup, log)) {
            log.error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("See %s -help for information about locating necessary files")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Setup$.MODULE$.Command()}));
                }
            });
            throw package$.MODULE$.exit(1);
        }
        Inputs vinputs = Inputs$.MODULE$.verify(inputs2);
        if (vinputs.cacheFile().getCanonicalPath().startsWith(Setup$.MODULE$.zincCacheDir().getPath())) {
            log.warn((Function0)new Serializable(vinputs){
                public static final long serialVersionUID = 0L;
                private final Inputs vinputs$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Default cache file location not accessible. Using ").append((Object)this.vinputs$1.cacheFile().getPath()).toString();
                }
                {
                    this.vinputs$1 = vinputs$1;
                }
            });
        }
        if (isDebug) {
            Serializable debug2 = new Serializable(log){
                public static final long serialVersionUID = 0L;
                private final Logger log$1;

                public final void apply(String x$2) {
                    this.log$1.debug((Function0)new Serializable(this, x$2){
                        public static final long serialVersionUID = 0L;
                        private final String x$2$1;

                        public final String apply() {
                            return this.x$2$1;
                        }
                        {
                            this.x$2$1 = x$2$1;
                        }
                    });
                }
                {
                    this.log$1 = log$1;
                }
            };
            Setup$.MODULE$.show(setup, (Function1<String, BoxedUnit>)debug2);
            Inputs$.MODULE$.show(vinputs, (Function1<String, BoxedUnit>)debug2);
            object = debug2.apply((Object)new StringBuilder().append((Object)"Setup and Inputs parsed ").append((Object)Util$.MODULE$.timing(startTime)).toString());
        } else {
            object = BoxedUnit.UNIT;
        }
        try {
            Compiler compiler = Compiler$.MODULE$.apply(setup, log);
            log.debug((Function0)new Serializable(compiler){
                public static final long serialVersionUID = 0L;
                private final Compiler compiler$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Zinc compiler = %s [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.compiler$1, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(this.compiler$1.hashCode()))}));
                }
                {
                    this.compiler$1 = compiler$1;
                }
            });
            compiler.compile(vinputs, cwd, log);
            log.info((Function0)new Serializable(startTime){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Compile success ").append((Object)Util$.MODULE$.timing(this.startTime$1)).toString();
                }
                {
                    this.startTime$1 = startTime$1;
                }
            });
            return;
        }
        catch (Exception exception) {
            String message;
            if (isDebug) {
                exception.printStackTrace();
            }
            if ((message = exception.getMessage()) == null) throw package$.MODULE$.exit(1);
            log.error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            throw package$.MODULE$.exit(1);
        }
        catch (CompileFailed compileFailed) {
            log.error((Function0)new Serializable(startTime){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Compile failed ").append((Object)Util$.MODULE$.timing(this.startTime$1)).toString();
                }
                {
                    this.startTime$1 = startTime$1;
                }
            });
            throw package$.MODULE$.exit(1);
        }
        finally {
            if (settings.consoleLog().printProgress() || settings.consoleLog().heartbeatSecs() > 0) {
                System.out.println("Done.");
            }
        }
    }

    private Main$() {
        MODULE$ = this;
    }
}

