/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc;

import java.io.File;
import java.util.List;
import org.pantsbuild.zinc.Compiler$;
import org.pantsbuild.zinc.IncOptions;
import org.pantsbuild.zinc.Inputs;
import org.pantsbuild.zinc.Inputs$;
import org.pantsbuild.zinc.Settings;
import org.pantsbuild.zinc.Settings$;
import org.pantsbuild.zinc.Setup$;
import org.pantsbuild.zinc.Util$;
import sbt.Logger;
import sbt.Logger$;
import sbt.Path$;
import sbt.inc.Analysis;
import sbt.inc.Analysis$;
import sbt.inc.Locate$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xsbti.compile.CompileOrder;

public final class Inputs$
implements Serializable {
    public static final Inputs$ MODULE$;

    static {
        new Inputs$();
    }

    public Inputs apply(Logger log, Settings settings) {
        return this.inputs(log, settings.classpath(), settings.sources(), settings.classesDirectory(), settings.scalacOptions(), settings.javacOptions(), settings.analysis().cache(), settings.analysis().cacheMap(), settings.analysis().forceClean(), settings.javaOnly(), settings.compileOrder(), settings.incOptions());
    }

    public Function1<String, Object> definesClass(Logger log, Map<File, Analysis> analysisMap, File entry) {
        return (Function1)analysisMap.get((Object)entry).map((Function1)new Serializable(log, entry){
            public static final long serialVersionUID = 0L;
            private final Logger log$2;
            public final File entry$1;

            public final Function1<String, Object> apply(Analysis analysis2) {
                this.log$2.debug((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.definesClass.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hit analysis cache for class definitions with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.entry$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return new Serializable(this, analysis2){
                    public static final long serialVersionUID = 0L;
                    private final Analysis analysis$1;

                    public final boolean apply(String s) {
                        return this.analysis$1.relations().definesClass(s).nonEmpty();
                    }
                    {
                        this.analysis$1 = analysis$1;
                    }
                };
            }
            {
                this.log$2 = log$2;
                this.entry$1 = entry$1;
            }
        }).getOrElse((Function0)new Serializable(entry){
            public static final long serialVersionUID = 0L;
            private final File entry$1;

            public final Function1<String, Object> apply() {
                return Locate$.MODULE$.definesClass(this.entry$1);
            }
            {
                this.entry$1 = entry$1;
            }
        });
    }

    public Inputs inputs(Logger log, Seq<File> classpath, Seq<File> sources, File classesDirectory, Seq<String> scalacOptions, Seq<String> javacOptions, Option<File> analysisCache, Map<File, File> analysisCacheMap, boolean forceClean, boolean javaOnly, CompileOrder compileOrder, IncOptions incOptions) {
        Serializable normalise = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(File x$1) {
                return x$1.getAbsoluteFile();
            }
        };
        Seq cp = (Seq)classpath.map((Function1)normalise, Seq$.MODULE$.canBuildFrom());
        Seq srcs = (Seq)sources.map((Function1)normalise, Seq$.MODULE$.canBuildFrom());
        File classes = (File)normalise.apply((Object)classesDirectory);
        File cacheFile = (File)normalise.apply(analysisCache.getOrElse((Function0)new Serializable(classesDirectory){
            public static final long serialVersionUID = 0L;
            private final File classesDirectory$1;

            public final File apply() {
                return Inputs$.MODULE$.defaultCacheLocation(this.classesDirectory$1);
            }
            {
                this.classesDirectory$1 = classesDirectory$1;
            }
        }));
        Map upstreamAnalysis = (Map)analysisCacheMap.map((Function1)new Serializable((Function1)normalise){
            public static final long serialVersionUID = 0L;
            private final Function1 normalise$1;

            public final Tuple2<File, File> apply(Tuple2<File, File> x0$1) {
                Tuple2<File, File> tuple2 = x0$1;
                if (tuple2 != null) {
                    File k = (File)tuple2._1();
                    File v = (File)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(this.normalise$1.apply((Object)k), this.normalise$1.apply((Object)v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.normalise$1 = normalise$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        Map validUpstreamAnalysis = (Map)upstreamAnalysis.flatMap((Function1)new Serializable(classes){
            public static final long serialVersionUID = 0L;
            private final File classes$1;

            public final Iterable<Tuple2<File, Analysis>> apply(Tuple2<File, File> x0$2) {
                Tuple2<File, File> tuple2;
                block4: {
                    Iterable iterable;
                    block3: {
                        block2: {
                            File k;
                            tuple2 = x0$2;
                            if (tuple2 == null) break block2;
                            File file = k = (File)tuple2._1();
                            File file2 = this.classes$1;
                            if (file != null ? !((Object)file).equals(file2) : file2 != null) break block2;
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        File k = (File)tuple2._1();
                        File v = (File)tuple2._2();
                        iterable = Option$.MODULE$.option2Iterable(Compiler$.MODULE$.analysisOption(v).map((Function1)new Serializable(this, k){
                            public static final long serialVersionUID = 0L;
                            private final File k$1;

                            public final Tuple2<File, Analysis> apply(Analysis analysis2) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.k$1), (Object)analysis2);
                            }
                            {
                                this.k$1 = k$1;
                            }
                        }));
                    }
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
            {
                this.classes$1 = classes$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        Map analysisMap = ((TraversableOnce)cp.map((Function1)new Serializable(classes, upstreamAnalysis){
            public static final long serialVersionUID = 0L;
            private final File classes$1;
            private final Map upstreamAnalysis$1;

            public final Tuple2<File, Analysis> apply(File file) {
                return new Tuple2((Object)file, (Object)Inputs$.MODULE$.allAnalysisFor(file, this.classes$1, (Map<File, File>)this.upstreamAnalysis$1));
            }
            {
                this.classes$1 = classes$1;
                this.upstreamAnalysis$1 = upstreamAnalysis$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        IncOptions incOpts = this.updateIncOptions(incOptions, classesDirectory, (Function1<File, File>)normalise);
        return new Inputs((Seq<File>)cp, (Seq<File>)srcs, classes, scalacOptions, javacOptions, cacheFile, (Map<File, Analysis>)analysisMap, forceClean, (Function1<File, Function1<String, Object>>)new Serializable(log, validUpstreamAnalysis){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;
            private final Map validUpstreamAnalysis$1;

            public final Function1<String, Object> apply(File x$2) {
                return Inputs$.MODULE$.definesClass(this.log$1, (Map<File, Analysis>)this.validUpstreamAnalysis$1, x$2);
            }
            {
                this.log$1 = log$1;
                this.validUpstreamAnalysis$1 = validUpstreamAnalysis$1;
            }
        }, javaOnly, compileOrder, incOpts);
    }

    public Inputs create(Logger log, List<File> classpath, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions, File analysisCache, java.util.Map<File, File> analysisMap, String compileOrder, IncOptions incOptions) {
        return this.inputs(log, (Seq<File>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(classpath).asScala()), (Seq<File>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(sources).asScala()), classesDirectory, (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(scalacOptions).asScala()), (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(javacOptions).asScala()), (Option<File>)Option$.MODULE$.apply((Object)analysisCache), (Map<File, File>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(analysisMap).asScala()).toMap(Predef$.MODULE$.conforms()), false, false, Settings$.MODULE$.compileOrder(compileOrder), incOptions);
    }

    public File defaultCacheLocation(File classesDir) {
        return Path$.MODULE$.richFile(Path$.MODULE$.richFile(classesDir.getParentFile()).$div("cache")).$div(classesDir.getName());
    }

    public Option<File> cacheFor(File file, File exclude, Map<File, File> mapped) {
        return mapped.get((Object)file).orElse((Function0)new Serializable(file, exclude){
            public static final long serialVersionUID = 0L;
            private final File file$1;
            private final File exclude$1;

            /*
             * Enabled aggressive block sorting
             */
            public final Option<File> apply() {
                None$ none$;
                if (this.file$1.isDirectory()) {
                    File file = this.file$1;
                    File file2 = this.exclude$1;
                    if (file == null ? file2 != null : !((Object)file).equals(file2)) {
                        none$ = new Some((Object)Inputs$.MODULE$.defaultCacheLocation(this.file$1));
                        return none$;
                    }
                }
                none$ = None$.MODULE$;
                return none$;
            }
            {
                this.file$1 = file$1;
                this.exclude$1 = exclude$1;
            }
        });
    }

    public Analysis allAnalysisFor(File file, File exclude, Map<File, File> mapped) {
        return (Analysis)this.cacheFor(file, exclude, mapped).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Analysis apply(File cacheFile) {
                return Compiler$.MODULE$.analysis(cacheFile);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Analysis apply() {
                return Analysis$.MODULE$.Empty();
            }
        });
    }

    public IncOptions updateIncOptions(IncOptions incOptions, File classesDir, Function1<File, File> normalise) {
        Option x$3 = incOptions.apiDumpDirectory().map(normalise);
        Option<File> x$4 = this.getBackupDirectory(incOptions, classesDir, normalise);
        int x$5 = incOptions.copy$default$1();
        double x$6 = incOptions.copy$default$2();
        boolean x$7 = incOptions.copy$default$3();
        boolean x$8 = incOptions.copy$default$4();
        int x$9 = incOptions.copy$default$5();
        boolean x$10 = incOptions.copy$default$7();
        boolean x$11 = incOptions.copy$default$9();
        boolean x$12 = incOptions.copy$default$10();
        return incOptions.copy(x$5, x$6, x$7, x$8, x$9, (Option<File>)x$3, x$10, x$4, x$11, x$12);
    }

    public Option<File> getBackupDirectory(IncOptions incOptions, File classesDir, Function1<File, File> normalise) {
        return incOptions.transactional() ? new Some(normalise.apply(incOptions.backup().getOrElse((Function0)new Serializable(classesDir){
            public static final long serialVersionUID = 0L;
            private final File classesDir$1;

            public final File apply() {
                return Inputs$.MODULE$.defaultBackupLocation(this.classesDir$1);
            }
            {
                this.classesDir$1 = classesDir$1;
            }
        }))) : None$.MODULE$;
    }

    public File defaultBackupLocation(File classesDir) {
        return Path$.MODULE$.richFile(Path$.MODULE$.richFile(classesDir.getParentFile()).$div("backup")).$div(classesDir.getName());
    }

    public Inputs verify(Inputs inputs2) {
        File x$13 = this.verifyCacheFile(inputs2.cacheFile(), inputs2.classesDirectory());
        Seq<File> x$14 = inputs2.copy$default$1();
        Seq<File> x$15 = inputs2.copy$default$2();
        File x$16 = inputs2.copy$default$3();
        Seq<String> x$17 = inputs2.copy$default$4();
        Seq<String> x$18 = inputs2.copy$default$5();
        Map<File, Analysis> x$19 = inputs2.copy$default$7();
        boolean x$20 = inputs2.copy$default$8();
        Function1<File, Function1<String, Object>> x$21 = inputs2.copy$default$9();
        boolean x$22 = inputs2.copy$default$10();
        CompileOrder x$23 = inputs2.copy$default$11();
        IncOptions x$24 = inputs2.copy$default$12();
        return inputs2.copy(x$14, x$15, x$16, x$17, x$18, x$13, x$19, x$20, x$21, x$22, x$23, x$24);
    }

    public File verifyCacheFile(File cacheFile, File classesDir) {
        return Util$.MODULE$.checkWritable(cacheFile) ? cacheFile : Path$.MODULE$.richFile(Path$.MODULE$.richFile(Setup$.MODULE$.zincCacheDir()).$div("analysis-cache")).$div(Util$.MODULE$.pathHash(classesDir));
    }

    public void debug(Inputs inputs2, xsbti.Logger log) {
        this.show(inputs2, (Function1<String, BoxedUnit>)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final xsbti.Logger log$3;

            public final void apply(String s) {
                this.log$3.debug(Logger$.MODULE$.f0((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final String s$1;

                    public final String apply() {
                        return this.s$1;
                    }
                    {
                        this.s$1 = s$1;
                    }
                }));
            }
            {
                this.log$3 = log$3;
            }
        });
    }

    public void show(Inputs inputs2, Function1<String, BoxedUnit> output) {
        Seq incOpts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"transitive step"), (Object)BoxesRunTime.boxToInteger((int)inputs2.incOptions().transitiveStep())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"recompile all fraction"), (Object)BoxesRunTime.boxToDouble((double)inputs2.incOptions().recompileAllFraction())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"debug relations"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.incOptions().relationsDebug())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"debug api"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.incOptions().apiDebug())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"api dump"), inputs2.incOptions().apiDumpDirectory()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"api diff context size"), (Object)BoxesRunTime.boxToInteger((int)inputs2.incOptions().apiDiffContextSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"transactional"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.incOptions().transactional())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"backup directory"), inputs2.incOptions().backup()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"recompile on macro def"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.incOptions().recompileOnMacroDef())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name hashing"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.incOptions().nameHashing()))}));
        Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"classpath"), inputs2.classpath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sources"), inputs2.sources()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"output directory"), (Object)inputs2.classesDirectory()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scalac options"), inputs2.scalacOptions()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"javac options"), inputs2.javacOptions()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"cache file"), (Object)inputs2.cacheFile()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"analysis map"), inputs2.analysisMap()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"force clean"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.forceClean())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"java only"), (Object)BoxesRunTime.boxToBoolean((boolean)inputs2.javaOnly())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"compile order"), (Object)inputs2.compileOrder()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"incremental compiler options"), (Object)incOpts)}));
        Util$.MODULE$.show(new Tuple2((Object)"Inputs", (Object)values), output, Util$.MODULE$.show$default$3(), Util$.MODULE$.show$default$4());
    }

    public Inputs apply(Seq<File> classpath, Seq<File> sources, File classesDirectory, Seq<String> scalacOptions, Seq<String> javacOptions, File cacheFile, Map<File, Analysis> analysisMap, boolean forceClean, Function1<File, Function1<String, Object>> definesClass2, boolean javaOnly, CompileOrder compileOrder, IncOptions incOptions) {
        return new Inputs(classpath, sources, classesDirectory, scalacOptions, javacOptions, cacheFile, analysisMap, forceClean, definesClass2, javaOnly, compileOrder, incOptions);
    }

    public Option<Tuple12<Seq<File>, Seq<File>, File, Seq<String>, Seq<String>, File, Map<File, Analysis>, Object, Function1<File, Function1<String, Object>>, Object, CompileOrder, IncOptions>> unapply(Inputs x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12(x$0.classpath(), x$0.sources(), (Object)x$0.classesDirectory(), x$0.scalacOptions(), x$0.javacOptions(), (Object)x$0.cacheFile(), x$0.analysisMap(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.forceClean()), x$0.definesClass(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.javaOnly()), (Object)x$0.compileOrder(), (Object)x$0.incOptions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Inputs$() {
        MODULE$ = this;
    }
}

