/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc;

import com.google.common.cache.Cache;
import java.io.File;
import java.net.URLClassLoader;
import org.pantsbuild.zinc.Cache$;
import org.pantsbuild.zinc.Compiler;
import org.pantsbuild.zinc.Compiler$;
import org.pantsbuild.zinc.Compiler$$anon$1$;
import org.pantsbuild.zinc.FileFPrint;
import org.pantsbuild.zinc.FileFPrint$;
import org.pantsbuild.zinc.Setup;
import org.pantsbuild.zinc.Setup$Defaults$;
import org.pantsbuild.zinc.Util$;
import sbt.ClasspathOptions$;
import sbt.CompileSetup;
import sbt.Path$;
import sbt.classpath.ClasspathUtilities$;
import sbt.compiler.AnalyzingCompiler;
import sbt.compiler.CompilerCache$;
import sbt.compiler.IC$;
import sbt.compiler.javac.JavaCompiler$;
import sbt.compiler.javac.JavaCompilerAdapter;
import sbt.compiler.javac.JavaTool;
import sbt.inc.Analysis;
import sbt.inc.Analysis$;
import sbt.inc.AnalysisStore;
import sbt.inc.AnalysisStore$;
import sbt.inc.FileBasedStore$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import xsbti.Logger;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.GlobalsCache;
import xsbti.compile.JavaCompiler;
import xsbti.compile.ScalaInstance;

public final class Compiler$ {
    public static final Compiler$ MODULE$;
    private final String CompilerInterfaceId;
    private final String JavaClassVersion;
    private final Cache<Setup, Compiler> compilerCache;
    private final GlobalsCache residentCache;
    private final Cache<FileFPrint, Option<Tuple2<Analysis, CompileSetup>>> analysisCache;

    static {
        new Compiler$();
    }

    public String CompilerInterfaceId() {
        return this.CompilerInterfaceId;
    }

    public String JavaClassVersion() {
        return this.JavaClassVersion;
    }

    public Cache<Setup, Compiler> compilerCache() {
        return this.compilerCache;
    }

    public GlobalsCache residentCache() {
        return this.residentCache;
    }

    public Cache<FileFPrint, Option<Tuple2<Analysis, CompileSetup>>> analysisCache() {
        return this.analysisCache;
    }

    public Compiler apply(Setup setup, Logger log) {
        return Cache$.MODULE$.Implicits(this.compilerCache()).getOrElseUpdate(setup, (Function0<Compiler>)new Serializable(setup, log){
            public static final long serialVersionUID = 0L;
            private final Setup setup$1;
            private final Logger log$1;

            public final Compiler apply() {
                return Compiler$.MODULE$.create(this.setup$1, this.log$1);
            }
            {
                this.setup$1 = setup$1;
                this.log$1 = log$1;
            }
        });
    }

    public Compiler getOrCreate(Setup setup, Logger log) {
        return this.apply(setup, log);
    }

    public Compiler create(Setup setup, Logger log) {
        sbt.ScalaInstance instance = this.scalaInstance(setup);
        File interfaceJar = this.compilerInterface(setup, instance, log);
        AnalyzingCompiler scalac = this.newScalaCompiler(instance, interfaceJar);
        JavaCompiler javac = this.newJavaCompiler(instance, setup.javaHome(), setup.forkJava());
        return new Compiler(scalac, javac);
    }

    public AnalyzingCompiler newScalaCompiler(sbt.ScalaInstance instance, File interfaceJar) {
        return IC$.MODULE$.newScalaCompiler((ScalaInstance)instance, interfaceJar, (ClasspathOptions)ClasspathOptions$.MODULE$.boot());
    }

    public JavaCompiler newJavaCompiler(sbt.ScalaInstance instance, Option<File> javaHome, boolean fork) {
        sbt.compiler.javac.JavaCompiler compiler = fork || javaHome.isDefined() ? JavaCompiler$.MODULE$.fork(javaHome) : (sbt.compiler.javac.JavaCompiler)JavaCompiler$.MODULE$.local().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final sbt.compiler.javac.JavaCompiler apply() {
                return JavaCompiler$.MODULE$.fork((Option)None$.MODULE$);
            }
        });
        sbt.ClasspathOptions options = ClasspathOptions$.MODULE$.javac(false);
        return new JavaCompilerAdapter((JavaTool)compiler, (ScalaInstance)instance, (ClasspathOptions)options);
    }

    public GlobalsCache createResidentCache(int maxCompilers) {
        return maxCompilers <= 0 ? CompilerCache$.MODULE$.fresh() : CompilerCache$.MODULE$.apply(maxCompilers);
    }

    public AnalysisStore analysisStore(File cacheFile) {
        AnalysisStore fileStore = AnalysisStore$.MODULE$.cached(FileBasedStore$.MODULE$.apply(cacheFile));
        AnalysisStore fprintStore = new AnalysisStore(cacheFile, fileStore){
            private final File cacheFile$1;
            public final AnalysisStore fileStore$1;

            public void set(Analysis analysis2, CompileSetup setup) {
                this.fileStore$1.set(analysis2, setup);
                FileFPrint$.MODULE$.fprint(this.cacheFile$1).foreach((Function1)new Serializable(this, analysis2, setup){
                    public static final long serialVersionUID = 0L;
                    private final Analysis analysis$1;
                    private final CompileSetup setup$2;

                    public final void apply(FileFPrint x$1) {
                        Compiler$.MODULE$.analysisCache().put((Object)x$1, (Object)new Some((Object)new Tuple2((Object)this.analysis$1, (Object)this.setup$2)));
                    }
                    {
                        this.analysis$1 = analysis$1;
                        this.setup$2 = setup$2;
                    }
                });
            }

            public Option<Tuple2<Analysis, CompileSetup>> get() {
                return FileFPrint$.MODULE$.fprint(this.cacheFile$1).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Option<Tuple2<Analysis, CompileSetup>> apply(FileFPrint fprint) {
                        return Cache$.MODULE$.Implicits(Compiler$.MODULE$.analysisCache()).getOrElseUpdate(fprint, (Function0<Option<Tuple2<Analysis, CompileSetup>>>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$1$$anonfun$get$1 $outer;

                            public final Option<Tuple2<Analysis, CompileSetup>> apply() {
                                return this.$outer.org$pantsbuild$zinc$Compiler$$anon$$anonfun$$$outer().fileStore$1.get();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anon.1 org$pantsbuild$zinc$Compiler$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.cacheFile$1 = cacheFile$1;
                this.fileStore$1 = fileStore$1;
            }
        };
        return AnalysisStore$.MODULE$.sync(AnalysisStore$.MODULE$.cached(fprintStore));
    }

    public Option<Analysis> analysisOption(File cacheFile) {
        return this.analysisStore(cacheFile).get().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Analysis apply(Tuple2<Analysis, CompileSetup> x$2) {
                return (Analysis)x$2._1();
            }
        });
    }

    public Analysis analysis(File cacheFile) {
        return (Analysis)this.analysisOption(cacheFile).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Analysis apply() {
                return Analysis$.MODULE$.Empty();
            }
        });
    }

    public boolean analysisIsEmpty(File cacheFile) {
        return this.analysis(cacheFile) == Analysis$.MODULE$.Empty();
    }

    public sbt.ScalaInstance scalaInstance(Setup setup) {
        File file = setup.scalaLibrary();
        File file2 = setup.scalaCompiler();
        URLClassLoader loader = this.scalaLoader((Seq<File>)((Seq)((SeqLike)setup.scalaExtra().$plus$colon((Object)file2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)file, Seq$.MODULE$.canBuildFrom())));
        Option<String> version = this.scalaVersion(loader);
        return new sbt.ScalaInstance((String)version.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown";
            }
        }), (ClassLoader)loader, setup.scalaLibrary(), setup.scalaCompiler(), setup.scalaExtra(), version);
    }

    public URLClassLoader scalaLoader(Seq<File> jars) {
        return new URLClassLoader(Path$.MODULE$.toURLs(jars), ClasspathUtilities$.MODULE$.rootLoader());
    }

    public Option<String> scalaVersion(ClassLoader scalaLoader) {
        return Util$.MODULE$.propertyFromResource("compiler.properties", "version.number", scalaLoader);
    }

    public File compilerInterface(Setup setup, sbt.ScalaInstance scalaInstance2, Logger log) {
        File dir = Path$.MODULE$.richFile(setup.cacheDir()).$div(this.interfaceId(scalaInstance2.actualVersion()));
        File interfaceJar = Path$.MODULE$.richFile(dir).$div(new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)".jar").toString());
        if (!interfaceJar.exists()) {
            dir.mkdirs();
            IC$.MODULE$.compileInterfaceJar(this.CompilerInterfaceId(), setup.compilerInterfaceSrc(), interfaceJar, setup.sbtInterface(), (ScalaInstance)scalaInstance2, log);
        }
        return interfaceJar;
    }

    public String interfaceId(String scalaVersion) {
        return new StringBuilder().append((Object)this.CompilerInterfaceId()).append((Object)"-").append((Object)scalaVersion).append((Object)"-").append((Object)this.JavaClassVersion()).toString();
    }

    private Compiler$() {
        MODULE$ = this;
        this.CompilerInterfaceId = "compiler-interface";
        this.JavaClassVersion = System.getProperty("java.class.version");
        this.compilerCache = Cache$.MODULE$.apply(Setup$Defaults$.MODULE$.compilerCacheLimit());
        this.residentCache = this.createResidentCache(Setup$Defaults$.MODULE$.residentCacheLimit());
        this.analysisCache = Cache$.MODULE$.apply(Setup$Defaults$.MODULE$.analysisCacheLimit());
    }
}

