/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils.http;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.indented.IndentedStringable;
import org.organicdesign.indented.StringUtils;
import org.organicdesign.testUtils.http.CookiePrinter;
import org.organicdesign.testUtils.http.Kv;
import org.organicdesign.testUtils.http.MultiPartFormInputStream;
import org.organicdesign.testUtils.http.ReqB;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0090\u00012\u00020\u00012\u00020\u0002:\u0002\u0090\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\bH\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010,\u001a\u00020\bH\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0.H\u0016J\b\u0010/\u001a\u00020\bH\u0016J\n\u00100\u001a\u0004\u0018\u00010\bH\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u001aH\u0016J\n\u00104\u001a\u0004\u0018\u00010\bH\u0016J\b\u00105\u001a\u00020\bH\u0016J\u0015\u00106\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u00107J\u0012\u00108\u001a\u00020\u001a2\b\u00109\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0014\u0010<\u001a\u0004\u0018\u00010\b2\b\u00109\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0.H\u0016J\u001a\u0010>\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010.2\b\u0010,\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0010\u0010A\u001a\u0002022\u0006\u0010,\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020\bH\u0016J\b\u0010C\u001a\u00020\bH\u0016J\b\u0010D\u001a\u000202H\u0016J\n\u0010E\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0.H\u0016J\b\u0010G\u001a\u00020\bH\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020\bH\u0016J\u001c\u0010I\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00140\u001fH\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\b0.H\u0016J\u001f\u0010K\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00142\u0006\u0010,\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010LJ\u0014\u0010M\u001a\u0004\u0018\u00010N2\b\u0010O\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010P\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010N\u0018\u00010QH\u0016J\"\u0010P\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010N\u0018\u00010Q2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0002J\n\u0010R\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010S\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010T\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010U\u001a\u00020\bH\u0016J\b\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0017J\b\u0010Y\u001a\u00020\bH\u0016J\b\u0010Z\u001a\u00020\bH\u0016J\b\u0010[\u001a\u000202H\u0016J\b\u0010\\\u001a\u00020\bH\u0016J\u0010\u0010]\u001a\u00020^2\u0006\u0010,\u001a\u00020\bH\u0016J\n\u0010_\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010`\u001a\u00020aH\u0016J\n\u0010b\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010c\u001a\u00020\bH\u0016J\b\u0010d\u001a\u00020\bH\u0016J\b\u0010e\u001a\u000202H\u0016J\b\u0010f\u001a\u00020gH\u0016J\n\u0010h\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010i\u001a\u00020jH\u0016J\u0010\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020%H\u0016J\b\u0010l\u001a\u00020mH\u0016J\u0018\u0010n\u001a\u00020\b2\u0006\u0010o\u001a\u0002022\u0006\u0010p\u001a\u00020%H\u0016J\b\u0010q\u001a\u00020%H\u0016J\b\u0010r\u001a\u00020%H\u0016J\b\u0010s\u001a\u00020%H\u0016J\b\u0010t\u001a\u00020%H\u0016J\b\u0010u\u001a\u00020%H\u0017J\b\u0010v\u001a\u00020%H\u0016J\b\u0010w\u001a\u00020%H\u0016J\u0010\u0010x\u001a\u00020%2\u0006\u0010,\u001a\u00020\bH\u0016J\u0018\u0010y\u001a\u00020z2\u0006\u0010,\u001a\u00020\b2\u0006\u0010{\u001a\u00020\bH\u0016J\b\u0010|\u001a\u00020zH\u0016J\u0012\u0010}\u001a\u00020\n2\b\u0010~\u001a\u0004\u0018\u00010\u007fH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020z2\u0006\u0010,\u001a\u00020\bH\u0016J\u001a\u0010\u0081\u0001\u001a\u00020z2\u0006\u0010,\u001a\u00020\b2\u0007\u0010\u0082\u0001\u001a\u00020\rH\u0016J\u0013\u0010\u0083\u0001\u001a\u00020z2\b\u0010,\u001a\u0004\u0018\u00010\bH\u0016J\t\u0010\u0084\u0001\u001a\u00020*H\u0016J\u001d\u0010\u0084\u0001\u001a\u00020*2\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\t\u0010\u0089\u0001\u001a\u00020\bH\u0016J-\u0010\u008a\u0001\u001a\u0003H\u008b\u0001\"\n\b\u0000\u0010\u008b\u0001*\u00030\u008c\u00012\u000f\u0010\u008d\u0001\u001a\n\u0012\u0005\u0012\u0003H\u008b\u00010\u008e\u0001H\u0016\u00a2\u0006\u0003\u0010\u008f\u0001R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lorg/organicdesign/testUtils/http/FakeHttpServletRequest;", "Ljakarta/servlet/http/HttpServletRequest;", "Lorg/organicdesign/indented/IndentedStringable;", "reqB", "Lorg/organicdesign/testUtils/http/ReqB;", "(Lorg/organicdesign/testUtils/http/ReqB;)V", "_contentParameters", "Lorg/eclipse/jetty/util/MultiMap;", "", "_multiParts", "Lorg/organicdesign/testUtils/http/MultiPartFormInputStream;", "attributes", "", "", "baseUrl", "characterEncoding", "cookies", "", "Ljakarta/servlet/http/Cookie;", "heads", "", "", "[Ljava/util/Map$Entry;", "inStream", "Ljava/io/ByteArrayInputStream;", "inStreamSize", "", "locale", "Ljava/util/Locale;", "method", "params", "", "", "remoteAddr", "requestedSessionId", "uri", "authenticate", "", "httpServletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "changeSessionId", "getAsyncContext", "Ljakarta/servlet/AsyncContext;", "getAttribute", "s", "getAttributeNames", "Ljava/util/Enumeration;", "getAuthType", "getCharacterEncoding", "getContentLength", "", "getContentLengthLong", "getContentType", "getContextPath", "getCookies", "()[Ljakarta/servlet/http/Cookie;", "getDateHeader", "p0", "getDispatcherType", "Ljakarta/servlet/DispatcherType;", "getHeader", "getHeaderNames", "getHeaders", "getInputStream", "Ljakarta/servlet/ServletInputStream;", "getIntHeader", "getLocalAddr", "getLocalName", "getLocalPort", "getLocale", "getLocales", "getMethod", "getParameter", "getParameterMap", "getParameterNames", "getParameterValues", "(Ljava/lang/String;)[Ljava/lang/String;", "getPart", "Ljakarta/servlet/http/Part;", "name", "getParts", "", "getPathInfo", "getPathTranslated", "getProtocol", "getQueryString", "getReader", "Ljava/io/BufferedReader;", "getRealPath", "getRemoteAddr", "getRemoteHost", "getRemotePort", "getRemoteUser", "getRequestDispatcher", "Ljakarta/servlet/RequestDispatcher;", "getRequestURI", "getRequestURL", "Ljava/lang/StringBuffer;", "getRequestedSessionId", "getScheme", "getServerName", "getServerPort", "getServletContext", "Ljakarta/servlet/ServletContext;", "getServletPath", "getSession", "Ljakarta/servlet/http/HttpSession;", "b", "getUserPrincipal", "Ljava/security/Principal;", "indentedStr", "indent", "singleLine", "isAsyncStarted", "isAsyncSupported", "isRequestedSessionIdFromCookie", "isRequestedSessionIdFromURL", "isRequestedSessionIdFromUrl", "isRequestedSessionIdValid", "isSecure", "isUserInRole", "login", "", "s1", "logout", "newMultiParts", "config", "Ljakarta/servlet/MultipartConfigElement;", "removeAttribute", "setAttribute", "o", "setCharacterEncoding", "startAsync", "servletRequest", "Ljakarta/servlet/ServletRequest;", "servletResponse", "Ljakarta/servlet/ServletResponse;", "toString", "upgrade", "T", "Ljakarta/servlet/http/HttpUpgradeHandler;", "aClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljakarta/servlet/http/HttpUpgradeHandler;", "Companion", "TestUtils"})
public final class FakeHttpServletRequest
implements HttpServletRequest,
IndentedStringable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @Nullable
    private final String uri;
    @NotNull
    private final String remoteAddr;
    @NotNull
    private final String method;
    @Nullable
    private String characterEncoding;
    @Nullable
    private final Locale locale;
    @Nullable
    private final String requestedSessionId;
    @Nullable
    private final ByteArrayInputStream inStream;
    private final long inStreamSize;
    @Nullable
    private MultiPartFormInputStream _multiParts;
    @Nullable
    private MultiMap<String> _contentParameters;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    private final Map<String, List<String>> params;
    @NotNull
    private final Map.Entry<String, String>[] heads;
    @NotNull
    private final List<Cookie> cookies;
    @NotNull
    public static final String HTTP_HEAD_HOST = "Host";
    @NotNull
    private static final Map<String, Integer> schemePorts;

    /*
     * WARNING - void declaration
     */
    public FakeHttpServletRequest(@NotNull ReqB reqB) {
        Map.Entry[] entryArray;
        boolean bl;
        block7: {
            boolean bl2;
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)reqB, (String)"reqB");
            this.baseUrl = reqB.getBaseUrl$TestUtils();
            this.uri = reqB.getUri$TestUtils();
            this.remoteAddr = reqB.getRemoteAddr$TestUtils();
            this.method = reqB.getMethod();
            this.characterEncoding = reqB.getCharacterEncoding$TestUtils();
            this.locale = reqB.getLocale$TestUtils();
            this.requestedSessionId = reqB.getRequestedSessionId$TestUtils();
            this.inStream = reqB.getInStream$TestUtils();
            this.inStreamSize = reqB.getInStreamSize$TestUtils();
            this.attributes = reqB.getAttributes$TestUtils();
            this.params = MapsKt.toMap(reqB.getParams$TestUtils());
            Iterable iterable = reqB.getHeaders$TestUtils();
            FakeHttpServletRequest fakeHttpServletRequest = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.equals((String)HTTP_HEAD_HOST, (String)((String)it.getKey()), (boolean)true)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = bl = false;
            }
        }
        if (bl) {
            Collection $this$toTypedArray$iv = reqB.getHeaders$TestUtils();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Map.Entry[] entryArray2 = thisCollection$iv.toArray(new Map.Entry[0]);
            if (entryArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            entryArray = entryArray2;
        } else {
            List hs = CollectionsKt.toMutableList((Collection)reqB.getHeaders$TestUtils());
            hs.add(new Kv(HTTP_HEAD_HOST, StringsKt.substringAfter$default((String)reqB.getBaseUrl$TestUtils(), (String)"//", null, (int)2, null)));
            Collection $this$toTypedArray$iv = hs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Map.Entry[] entryArray3 = thisCollection$iv.toArray(new Map.Entry[0]);
            if (entryArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            entryArray = entryArray3;
        }
        fakeHttpServletRequest.heads = entryArray;
        this.cookies = reqB.getCookies$TestUtils();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String indentedStr(int indent, boolean singleLine) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection<CookiePrinter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Pair[11];
        object[0] = TuplesKt.to((Object)"url", (Object)this.getRequestURL().toString());
        object[1] = TuplesKt.to((Object)"remoteAddr", (Object)this.remoteAddr);
        object[2] = TuplesKt.to((Object)"method", (Object)this.method);
        object[3] = TuplesKt.to((Object)"encoding", (Object)this.characterEncoding);
        object[4] = TuplesKt.to((Object)"locale", (Object)this.locale);
        object[5] = TuplesKt.to((Object)"requestedSessionId", (Object)this.requestedSessionId);
        object[6] = TuplesKt.to((Object)"inputStream", (Object)this.inStream);
        object[7] = TuplesKt.to((Object)"attributes", this.attributes);
        Iterable iterable = this.cookies;
        String string = "cookies";
        int n = 8;
        Object object2 = object;
        String string2 = "FakeHttpServletRequest";
        int n2 = indent;
        StringUtils stringUtils = StringUtils.INSTANCE;
        boolean $i$f$map22 = false;
        void var6_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cookie cookie = (Cookie)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CookiePrinter((Cookie)it));
        }
        collection = (List)destination$iv$iv;
        object2[n] = TuplesKt.to((Object)string, (Object)collection);
        object[9] = TuplesKt.to((Object)"params", this.params);
        object[10] = TuplesKt.to((Object)"headers", this.heads);
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$filter = false;
        void $i$f$map22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        object2 = (List)destination$iv$iv2;
        return stringUtils.classFieldsK(n2, string2, (Iterable)object2, singleLine);
    }

    @NotNull
    public String toString() {
        String string = this.indentedStr(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indentedStr(0)");
        return string;
    }

    @NotNull
    public StringBuffer getRequestURL() {
        StringBuffer sB = new StringBuffer(this.baseUrl);
        if (this.uri != null) {
            sB.append(this.uri);
        }
        return sB;
    }

    @Nullable
    public String getPathInfo() {
        return this.uri;
    }

    @Nullable
    public String getRequestURI() {
        return this.uri;
    }

    @Nullable
    public String getServletPath() {
        return this.uri;
    }

    @NotNull
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @NotNull
    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(@Nullable String s) {
        this.characterEncoding = s;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public Enumeration<Locale> getLocales() {
        return Companion.enumeration(CollectionsKt.listOf((Object)this.locale));
    }

    @Nullable
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Nullable
    public ServletInputStream getInputStream() {
        return this.inStream == null ? (ServletInputStream)null : (ServletInputStream)new Companion.FakeServletInputStream(this.inStream);
    }

    public int getContentLength() {
        return this.inStreamSize > Integer.MAX_VALUE ? -1 : (int)this.inStreamSize;
    }

    public long getContentLengthLong() {
        return this.inStreamSize;
    }

    @Nullable
    public Object getAttribute(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.attributes.get(s);
    }

    @NotNull
    public Enumeration<String> getAttributeNames() {
        return Companion.enumeration((Iterable)this.attributes.keySet());
    }

    public void setAttribute(@NotNull String s, @NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.attributes.put(s, o);
    }

    public void removeAttribute(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.attributes.remove(s);
    }

    @NotNull
    public Enumeration<String> getParameterNames() {
        return Companion.enumeration((Iterable)this.params.keySet());
    }

    @Nullable
    public String[] getParameterValues(@NotNull String s) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        List<String> list = this.params.get(s);
        if (list == null) {
            stringArray = null;
        } else {
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Nullable
    public String getParameter(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String[] stringArray = this.getParameterValues(s);
        return stringArray == null ? null : stringArray[0];
    }

    @NotNull
    public Map<String, String[]> getParameterMap() {
        Map ret = new LinkedHashMap();
        for (Map.Entry<String, List<String>> entry : this.params.entrySet()) {
            Collection $this$toTypedArray$iv = entry.getValue();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ret.put(entry.getKey(), stringArray);
        }
        return ret;
    }

    @NotNull
    public String getQueryString() {
        StringBuilder sB = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.params.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            for (String v : value) {
                sB.append(((CharSequence)sB).length() > 0 ? "&" : "").append(key).append("=").append(v);
            }
        }
        String string = sB.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sB.toString()");
        return string;
    }

    @Nullable
    public String getHeader(@Nullable String p0) {
        if (p0 != null) {
            for (Map.Entry<String, String> head : this.heads) {
                if (!StringsKt.equals((String)p0, (String)head.getKey(), (boolean)true)) continue;
                return head.getValue();
            }
        }
        return null;
    }

    @Nullable
    public Enumeration<String> getHeaders(@Nullable String s) {
        String header;
        String string = header = this.getHeader(s);
        return string == null ? null : Companion.enumeration(CollectionsKt.listOf((Object)string));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Enumeration<String> getHeaderNames() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry<String, String>[] entryArray = this.heads;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return companion.enumeration(CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
    }

    public int getIntHeader(@NotNull String s) {
        int n;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            n = Integer.parseInt(this.getHeader(s));
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public long getDateHeader(@Nullable String p0) {
        long l;
        String string = this.getHeader(p0);
        return string == null ? -1L : (l = Long.parseLong(string));
    }

    @Nullable
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Nullable
    public Cookie[] getCookies() {
        Cookie[] cookieArray;
        if (this.cookies.isEmpty()) {
            cookieArray = null;
        } else {
            Collection $this$toTypedArray$iv = this.cookies;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Cookie[] cookieArray2 = thisCollection$iv.toArray(new Cookie[0]);
            if (cookieArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            cookieArray = cookieArray2;
        }
        return cookieArray;
    }

    @NotNull
    public String getAuthType() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Nullable
    public String getPathTranslated() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getContextPath() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getRemoteUser() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isUserInRole(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public HttpSession getSession(boolean b) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public HttpSession getSession() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String changeSessionId() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated(message="")
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean authenticate(@NotNull HttpServletResponse httpServletResponse) {
        Intrinsics.checkNotNullParameter((Object)httpServletResponse, (String)"httpServletResponse");
        throw new UnsupportedOperationException("Not implemented");
    }

    public void login(@NotNull String s, @NotNull String s1) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        throw new UnsupportedOperationException("Not implemented");
    }

    public void logout() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public Part getPart(@Nullable String name) throws IOException, ServletException {
        this.getParts();
        MultiPartFormInputStream multiPartFormInputStream = this._multiParts;
        Intrinsics.checkNotNull((Object)multiPartFormInputStream);
        return multiPartFormInputStream.getPart(name);
    }

    @Nullable
    public Collection<Part> getParts() throws IOException, ServletException {
        String contentType = this.getContentType();
        if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.valueParameters((String)contentType, null))) {
            throw new ServletException("Unsupported Content-Type [" + contentType + "], expected [multipart/form-data]");
        }
        return this.getParts(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<Part> getParts(MultiMap<String> params) throws IOException {
        if (this._multiParts == null) {
            Charset charset;
            Charset charset2;
            Object object;
            Part charsetPart;
            File tmpDir = Files.createTempDirectory("testUtilTestTemp", new FileAttribute[0]).toFile();
            MultipartConfigElement config = new MultipartConfigElement(tmpDir.getAbsolutePath(), 100000L, 100000L, 0);
            MultiPartFormInputStream multiPartFormInputStream = this._multiParts = this.newMultiParts(config);
            Intrinsics.checkNotNull((Object)multiPartFormInputStream);
            Collection<Part> parts = multiPartFormInputStream.getParts();
            String formCharset = null;
            MultiPartFormInputStream multiPartFormInputStream2 = this._multiParts;
            Intrinsics.checkNotNull((Object)multiPartFormInputStream2);
            Part part = charsetPart = multiPartFormInputStream2.getPart("_charset_");
            if (part != null) {
                InputStream inputStream = part.getInputStream();
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream is = (InputStream)closeable;
                        boolean bl = false;
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        IO.copy((InputStream)is, (OutputStream)os);
                        object = os.toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"os.toByteArray()");
                        Charset charset3 = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
                        formCharset = new String((byte[])object, charset3);
                        is = Unit.INSTANCE;
                    }
                    catch (Throwable is) {
                        throwable = is;
                        throw is;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            if (formCharset != null) {
                charset2 = Charset.forName(formCharset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(formCharset)");
                charset = charset2;
            } else if (this.getCharacterEncoding() != null) {
                charset2 = Charset.forName(this.getCharacterEncoding());
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(getCharacterEncoding())");
                charset = charset2;
            } else {
                charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                charset = charset2;
            }
            Charset defaultCharset = charset;
            ByteArrayOutputStream os = null;
            for (Part p : parts) {
                if (p.getSubmittedFileName() != null) continue;
                String charset4 = null;
                if (p.getContentType() != null) {
                    charset4 = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                }
                Closeable closeable = p.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream is = (InputStream)closeable;
                    boolean bl = false;
                    if (os == null) {
                        os = new ByteArrayOutputStream();
                    }
                    IO.copy((InputStream)is, (OutputStream)os);
                    byte[] byArray = os.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os!!.toByteArray()");
                    String string = charset4;
                    Charset charset5 = string == null ? defaultCharset : Charset.forName(string);
                    Intrinsics.checkNotNullExpressionValue((Object)charset5, (String)"if (charset == null) def\u2026 Charset.forName(charset)");
                    String content = new String(byArray, charset5);
                    if (this._contentParameters == null) {
                        MultiMap multiMap = params;
                        if (multiMap == null) {
                            multiMap = new MultiMap();
                        }
                        this._contentParameters = multiMap;
                    }
                    MultiMap<String> multiMap = this._contentParameters;
                    Intrinsics.checkNotNull(multiMap);
                    multiMap.add(p.getName(), (Object)content);
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                os.reset();
            }
        }
        MultiPartFormInputStream multiPartFormInputStream = this._multiParts;
        Intrinsics.checkNotNull((Object)multiPartFormInputStream);
        return multiPartFormInputStream.getParts();
    }

    private final MultiPartFormInputStream newMultiParts(MultipartConfigElement config) throws IOException {
        return new MultiPartFormInputStream((InputStream)this.getInputStream(), this.getContentType(), config, null);
    }

    @NotNull
    public <T extends HttpUpgradeHandler> T upgrade(@NotNull Class<T> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public String getProtocol() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getScheme() {
        return StringsKt.substringBefore$default((String)this.baseUrl, (String)"://", null, (int)2, null);
    }

    @NotNull
    public String getServerName() {
        String string = this.getHeader(HTTP_HEAD_HOST);
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null);
    }

    public int getServerPort() {
        String string = this.getHeader(HTTP_HEAD_HOST);
        Intrinsics.checkNotNull((Object)string);
        String host = string;
        return StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null) ? Integer.parseInt(StringsKt.substringAfter$default((String)host, (String)":", null, (int)2, null)) : ((Number)schemePorts.getOrDefault(this.getScheme(), 0)).intValue();
    }

    @NotNull
    public BufferedReader getReader() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getRemoteHost() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RequestDispatcher getRequestDispatcher(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated(message="")
    @NotNull
    public String getRealPath(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getLocalName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public String getLocalAddr() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public AsyncContext startAsync(@NotNull ServletRequest servletRequest, @NotNull ServletResponse servletResponse) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("Not implemented");
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"https", (Object)443), TuplesKt.to((Object)"http", (Object)80), TuplesKt.to((Object)"ftp", (Object)21)};
        schemePorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/organicdesign/testUtils/http/FakeHttpServletRequest$Companion;", "", "()V", "HTTP_HEAD_HOST", "", "schemePorts", "", "", "enumeration", "Ljava/util/Enumeration;", "E", "iterable", "", "FakeServletInputStream", "TestUtils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <E> Enumeration<E> enumeration(@NotNull Iterable<? extends E> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            return new Enumeration<E>(iterable){
                @NotNull
                private Iterator<? extends E> iter;
                final /* synthetic */ Iterable<E> $iterable;
                {
                    this.$iterable = $iterable;
                    this.iter = this.$iterable.iterator();
                }

                @NotNull
                public final Iterator<E> getIter() {
                    return this.iter;
                }

                public final void setIter(@NotNull Iterator<? extends E> iterator) {
                    Intrinsics.checkNotNullParameter(iterator, (String)"<set-?>");
                    this.iter = iterator;
                }

                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                public E nextElement() {
                    return this.iter.next();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/organicdesign/testUtils/http/FakeHttpServletRequest$Companion$FakeServletInputStream;", "Ljakarta/servlet/ServletInputStream;", "inStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "eosReached", "", "isFinished", "isReady", "read", "", "b", "", "off", "len", "setReadListener", "", "p0", "Ljakarta/servlet/ReadListener;", "TestUtils"})
        private static final class FakeServletInputStream
        extends ServletInputStream {
            @NotNull
            private final InputStream inStream;
            private boolean eosReached;

            public FakeServletInputStream(@NotNull InputStream inStream) {
                Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
                this.inStream = inStream;
            }

            public boolean isReady() {
                return !this.eosReached;
            }

            public boolean isFinished() {
                return this.eosReached;
            }

            public void setReadListener(@Nullable ReadListener p0) {
                throw new UnsupportedOperationException("Not Implemented");
            }

            public int read() throws IOException {
                int ret = this.inStream.read();
                if (ret == -1) {
                    this.eosReached = true;
                }
                return ret;
            }

            public int read(@NotNull byte[] b, int off, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                int ret = this.inStream.read(b, off, len);
                if (ret == -1) {
                    this.eosReached = true;
                }
                return ret;
            }
        }
    }
}

