/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.organicdesign.testUtils.EqualsContract;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007J0\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0007J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007J8\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/organicdesign/testUtils/EqualsContract;", "", "()V", "equalsDistinctHashCode", "", "equiv1", "equiv2", "equiv3", "different", "equalsHashCode", "requireDistinctHashes", "", "equalsSameHashCode", "permutations", "T", "items", "", "f", "Lkotlin/Function2;", "TestUtils"})
public final class EqualsContract {
    @NotNull
    public static final EqualsContract INSTANCE = new EqualsContract();

    private EqualsContract() {
    }

    @JvmStatic
    public static final <T> void permutations(@NotNull List<? extends T> items, @NotNull Function2<? super T, ? super T, ? extends Object> f) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        int n = 0;
        int n2 = items.size() + -1;
        if (n <= n2) {
            do {
                int n3;
                int i;
                int n4;
                if ((n4 = (i = n++) + 1) >= (n3 = items.size())) continue;
                do {
                    int j = n4++;
                    f.invoke(items.get(i), items.get(j));
                } while (n4 < n3);
            } while (n <= n2);
        }
    }

    @JvmStatic
    public static final void equalsHashCode(@NotNull Object equiv1, @NotNull Object equiv2, @NotNull Object equiv3, @NotNull Object different, boolean requireDistinctHashes) {
        Intrinsics.checkNotNullParameter((Object)equiv1, (String)"equiv1");
        Intrinsics.checkNotNullParameter((Object)equiv2, (String)"equiv2");
        Intrinsics.checkNotNullParameter((Object)equiv3, (String)"equiv3");
        Intrinsics.checkNotNullParameter((Object)different, (String)"different");
        boolean bl = equiv1 != equiv2 && equiv1 != equiv3 && equiv1 != different && equiv2 != equiv3 && equiv2 != different && equiv3 != different;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You must provide four different (having different memory locations) but 3 equivalent objects";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{equiv1, equiv2, equiv3};
        List equivs = CollectionsKt.listOf((Object[])objectArray);
        Assert.assertFalse((String)"The different param should not allow itself to equal null", (boolean)false);
        Assert.assertEquals((String)"The different param must have the same hashCode as itself", (long)different.hashCode(), (long)different.hashCode());
        Assert.assertTrue((String)"The different param must equal itself", (boolean)Intrinsics.areEqual((Object)different, (Object)different));
        int i = 0;
        for (Object equiv : equivs) {
            int n = i;
            i = n + 1;
            Assert.assertEquals((String)("Param " + i + " must have the same hashCode as itself"), (long)equiv.hashCode(), (long)equiv.hashCode());
            if (requireDistinctHashes) {
                Assert.assertNotEquals((String)("The hashCode of param " + i + " must not equal the hashCode of the different param.  If you meant to do that, use equalsSameHashCode() instead."), (long)equiv.hashCode(), (long)different.hashCode());
            } else {
                Assert.assertEquals((String)("The hashCode of param " + i + " must equal the hashCode of the different param  If you meant to do that, use equalsDistinctHashCode() instead."), (long)equiv.hashCode(), (long)different.hashCode());
            }
            Assert.assertTrue((String)("Param " + i + " must be equal to itself"), (boolean)Intrinsics.areEqual(equiv, equiv));
            Assert.assertFalse((String)("Param " + i + " cannot be equal to the different param"), (boolean)Intrinsics.areEqual(equiv, (Object)different));
            Assert.assertFalse((String)("The different param cannot be equal to param " + i), (boolean)Intrinsics.areEqual((Object)different, equiv));
            Assert.assertFalse((String)("Param " + i + " cannot allow itself to equal null"), (equiv == null ? 1 : 0) != 0);
        }
        EqualsContract.permutations(equivs, equalsHashCode.2.INSTANCE);
    }

    @JvmStatic
    public static final void equalsSameHashCode(@NotNull Object equiv1, @NotNull Object equiv2, @NotNull Object equiv3, @NotNull Object different) {
        Intrinsics.checkNotNullParameter((Object)equiv1, (String)"equiv1");
        Intrinsics.checkNotNullParameter((Object)equiv2, (String)"equiv2");
        Intrinsics.checkNotNullParameter((Object)equiv3, (String)"equiv3");
        Intrinsics.checkNotNullParameter((Object)different, (String)"different");
        EqualsContract.equalsHashCode(equiv1, equiv2, equiv3, different, false);
    }

    @JvmStatic
    public static final void equalsDistinctHashCode(@NotNull Object equiv1, @NotNull Object equiv2, @NotNull Object equiv3, @NotNull Object different) {
        Intrinsics.checkNotNullParameter((Object)equiv1, (String)"equiv1");
        Intrinsics.checkNotNullParameter((Object)equiv2, (String)"equiv2");
        Intrinsics.checkNotNullParameter((Object)equiv3, (String)"equiv3");
        Intrinsics.checkNotNullParameter((Object)different, (String)"different");
        EqualsContract.equalsHashCode(equiv1, equiv2, equiv3, different, true);
    }
}

