/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.organicdesign.testUtils.EqualsContract;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\fH\u0002J9\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u000e\u001a\u0002H\u00052\u0006\u0010\u000f\u001a\u0002H\u00052\u0006\u0010\u0010\u001a\u0002H\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\fH\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract;", "", "()V", "pairComp", "", "T", "first", "Lorg/organicdesign/testUtils/ComparatorContract$Named;", "comp", "Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "second", "comparator", "Ljava/util/Comparator;", "testComparator", "least1", "middle1", "greatest1", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)V", "CompToZero", "Named", "TestUtils"})
public final class ComparatorContract {
    @NotNull
    public static final ComparatorContract INSTANCE = new ComparatorContract();

    private ComparatorContract() {
    }

    private final <T> void pairComp(Named<T> first, CompToZero comp, Named<T> second, Comparator<T> comparator) {
        Assert.assertTrue((String)("The " + first.getName() + " item must be " + comp.english() + " the " + second.getName()), (boolean)comp.vsZero(comparator.compare(first.getA(), second.getA())));
    }

    @JvmStatic
    public static final <T> void testComparator(T least1, T middle1, T greatest1, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Ref.BooleanRef anySame = new Ref.BooleanRef();
        Object[] objectArray = new Object[]{least1, middle1, greatest1};
        EqualsContract.permutations(CollectionsKt.listOf((Object[])objectArray), (Function2)new Function2<T, T, Unit>(anySame){
            final /* synthetic */ Ref.BooleanRef $anySame;
            {
                this.$anySame = $anySame;
                super(2);
            }

            public final void invoke(T a, T b) {
                if (a == b) {
                    this.$anySame.element = true;
                }
            }
        });
        boolean bl = !anySame.element;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean $i$a$-require-ComparatorContract$testComparator$32 = false;
            String string = "You must provide three pair of different objects in order";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int i = 0;
        Object[] objectArray2 = new Object[]{least1, middle1, greatest1};
        for (Object item : CollectionsKt.listOf((Object[])objectArray2)) {
            int $i$a$-require-ComparatorContract$testComparator$32 = i;
            i = $i$a$-require-ComparatorContract$testComparator$32 + 1;
            try {
                comparator.compare(item, null);
                Assert.fail((String)("comparator.compare(item, null) should throw some kind of RuntimeException (NullPointer/IllegalArgument/IllegalState, etc.) even though e.equals(null) returns false. Item " + i + " threw no exception."));
            }
            catch (RuntimeException $i$a$-require-ComparatorContract$testComparator$32) {
                // empty catch block
            }
            try {
                comparator.compare(null, item);
                Assert.fail((String)("comparator.compare(null, item) should throw some kind of RuntimeException (NullPointer/IllegalArgument/IllegalState, etc.) even though e.equals(null) returns false. Item " + i + " threw no exception."));
            }
            catch (RuntimeException $i$a$-require-ComparatorContract$testComparator$32) {}
        }
        Named<T> least = new Named<T>(least1, "Least");
        Named<T> middle = new Named<T>(middle1, "Middle");
        Named<T> greatest = new Named<T>(greatest1, "Greatest");
        Object[] objectArray3 = new Named[]{least, middle, greatest};
        for (Named pair : CollectionsKt.listOf((Object[])objectArray3)) {
            INSTANCE.pairComp(pair, CompToZero.EQZ, pair, comparator);
        }
        INSTANCE.pairComp(least, CompToZero.LTZ, middle, comparator);
        INSTANCE.pairComp(least, CompToZero.LTZ, greatest, comparator);
        INSTANCE.pairComp(middle, CompToZero.LTZ, greatest, comparator);
        INSTANCE.pairComp(greatest, CompToZero.GTZ, middle, comparator);
        INSTANCE.pairComp(greatest, CompToZero.GTZ, least, comparator);
        INSTANCE.pairComp(middle, CompToZero.GTZ, least, comparator);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "", "(Ljava/lang/String;I)V", "english", "", "vsZero", "", "i", "", "LTZ", "GTZ", "EQZ", "TestUtils"})
    public static final abstract class CompToZero
    extends Enum<CompToZero> {
        public static final /* enum */ CompToZero LTZ = new LTZ("LTZ", 0);
        public static final /* enum */ CompToZero GTZ = new GTZ("GTZ", 1);
        public static final /* enum */ CompToZero EQZ = new EQZ("EQZ", 2);
        private static final /* synthetic */ CompToZero[] $VALUES;

        private CompToZero() {
        }

        @NotNull
        public abstract String english();

        public abstract boolean vsZero(int var1);

        public static CompToZero[] values() {
            return (CompToZero[])$VALUES.clone();
        }

        public static CompToZero valueOf(String value) {
            return Enum.valueOf(CompToZero.class, value);
        }

        public /* synthetic */ CompToZero(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = compToZeroArray = new CompToZero[]{CompToZero.LTZ, CompToZero.GTZ, CompToZero.EQZ};
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract$CompToZero$LTZ;", "Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "english", "", "vsZero", "", "i", "", "TestUtils"})
        static final class LTZ
        extends CompToZero {
            /*
             * WARNING - void declaration
             */
            LTZ() {
                void var1_1;
            }

            @Override
            @NotNull
            public String english() {
                return "less than";
            }

            @Override
            public boolean vsZero(int i) {
                return i < 0;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract$CompToZero$GTZ;", "Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "english", "", "vsZero", "", "i", "", "TestUtils"})
        static final class GTZ
        extends CompToZero {
            /*
             * WARNING - void declaration
             */
            GTZ() {
                void var1_1;
            }

            @Override
            @NotNull
            public String english() {
                return "greater than";
            }

            @Override
            public boolean vsZero(int i) {
                return i > 0;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract$CompToZero$EQZ;", "Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "english", "", "vsZero", "", "i", "", "TestUtils"})
        static final class EQZ
        extends CompToZero {
            /*
             * WARNING - void declaration
             */
            EQZ() {
                void var1_1;
            }

            @Override
            @NotNull
            public String english() {
                return "equal to";
            }

            @Override
            public boolean vsZero(int i) {
                return i == 0;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/organicdesign/testUtils/ComparatorContract$Named;", "T", "", "a", "name", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getA", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getName", "()Ljava/lang/String;", "TestUtils"})
    private static final class Named<T> {
        private final T a;
        @NotNull
        private final String name;

        public Named(T a, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.a = a;
            this.name = name;
        }

        public final T getA() {
            return this.a;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }
}

