/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.organicdesign.testUtils.BreakNullSafety;
import org.organicdesign.testUtils.ComparatorContract;
import org.organicdesign.testUtils.EqualsContract;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0002JM\u0010\f\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\r\u001a\u0002H\u00052\u0006\u0010\u000e\u001a\u0002H\u00052\u0006\u0010\u000f\u001a\u0002H\u00052\u0006\u0010\u0010\u001a\u0002H\u00052\u0006\u0010\u0011\u001a\u0002H\u00052\u0006\u0010\u0012\u001a\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/organicdesign/testUtils/ComparableContract;", "", "()V", "pairComp", "", "S", "", "first", "Lorg/organicdesign/testUtils/ComparableContract$NamedPair;", "comp", "Lorg/organicdesign/testUtils/ComparatorContract$CompToZero;", "second", "testCompareTo", "least1", "least2", "middle1", "middle2", "greatest1", "greatest2", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;)V", "NamedPair", "TestUtils"})
public final class ComparableContract {
    @NotNull
    public static final ComparableContract INSTANCE = new ComparableContract();

    private ComparableContract() {
    }

    private final <S extends Comparable<? super S>> void pairComp(NamedPair<S> first, ComparatorContract.CompToZero comp, NamedPair<S> second) {
        Assert.assertTrue((String)("Item A in the " + first.getName() + " pair must be " + comp.english() + " item A in the " + second.getName() + " pair"), (boolean)comp.vsZero(first.getA().compareTo(second.getA())));
        Assert.assertTrue((String)("Item A in the " + first.getName() + " pair must be " + comp.english() + " item B in the " + second.getName() + " pair"), (boolean)comp.vsZero(first.getA().compareTo(second.getB())));
        Assert.assertTrue((String)("Item B in the " + first.getName() + " pair must be " + comp.english() + " item A in the " + second.getName() + " pair"), (boolean)comp.vsZero(first.getB().compareTo(second.getA())));
        Assert.assertTrue((String)("Item B in the " + first.getName() + " pair must be " + comp.english() + " item B in the " + second.getName() + " pair"), (boolean)comp.vsZero(first.getB().compareTo(second.getB())));
    }

    @JvmStatic
    public static final <S extends Comparable<? super S>> void testCompareTo(@NotNull S least1, @NotNull S least2, @NotNull S middle1, @NotNull S middle2, @NotNull S greatest1, @NotNull S greatest2) {
        Intrinsics.checkNotNullParameter(least1, (String)"least1");
        Intrinsics.checkNotNullParameter(least2, (String)"least2");
        Intrinsics.checkNotNullParameter(middle1, (String)"middle1");
        Intrinsics.checkNotNullParameter(middle2, (String)"middle2");
        Intrinsics.checkNotNullParameter(greatest1, (String)"greatest1");
        Intrinsics.checkNotNullParameter(greatest2, (String)"greatest2");
        Ref.BooleanRef anySame = new Ref.BooleanRef();
        Object[] objectArray = new Comparable[]{least1, least2, middle1, middle2, greatest1, greatest2};
        EqualsContract.permutations(CollectionsKt.listOf((Object[])objectArray), (Function2)new Function2<S, S, Unit>(anySame){
            final /* synthetic */ Ref.BooleanRef $anySame;
            {
                this.$anySame = $anySame;
                super(2);
            }

            public final void invoke(@NotNull S a, @NotNull S b) {
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                if (a == b) {
                    this.$anySame.element = true;
                }
            }
        });
        boolean bl = !anySame.element;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "You must provide three pair of different objects in order";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        NamedPair<S> least = new NamedPair<S>(least1, least2, "Least");
        NamedPair<S> middle = new NamedPair<S>(middle1, middle2, "Middle");
        NamedPair<S> greatest = new NamedPair<S>(greatest1, greatest2, "Greatest");
        NamedPair[] namedPairArray = new NamedPair[]{least, middle, greatest};
        for (NamedPair comp : CollectionsKt.listOf((Object[])namedPairArray)) {
            INSTANCE.pairComp(comp, ComparatorContract.CompToZero.EQZ, comp);
            Assert.assertEquals((String)(comp.getName() + " A must be compatibly equal to its paired B element"), comp.getA(), comp.getB());
            Assert.assertEquals((String)(comp.getName() + " B must be compatibly equal to its paired A element"), comp.getB(), comp.getA());
        }
        int i = 0;
        Object[] objectArray2 = new Comparable[]{least1, least2, middle1, middle2, greatest1, greatest2};
        for (Comparable comp : CollectionsKt.listOf((Object[])objectArray2)) {
            int n = i;
            i = n + 1;
            Assert.assertEquals((String)("item.equals(itself) should have returned true for item " + i), (Object)comp, (Object)comp);
            try {
                BreakNullSafety.INSTANCE.compareToNull(comp);
                Assert.fail((String)("e.compareTo(null) should throw some kind of RuntimeException (NullPointer/IllegalArgument/IllegalState, etc.) even though e.equals(null) returns false. Item " + i + " threw no exception!"));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Assert.assertNotEquals((String)("item.equals(null) should always be false.  Item " + i + " failed"), null, (Object)comp);
        }
        INSTANCE.pairComp(least, ComparatorContract.CompToZero.LTZ, middle);
        INSTANCE.pairComp(least, ComparatorContract.CompToZero.LTZ, greatest);
        INSTANCE.pairComp(middle, ComparatorContract.CompToZero.LTZ, greatest);
        INSTANCE.pairComp(greatest, ComparatorContract.CompToZero.GTZ, middle);
        INSTANCE.pairComp(greatest, ComparatorContract.CompToZero.GTZ, least);
        INSTANCE.pairComp(middle, ComparatorContract.CompToZero.GTZ, least);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/organicdesign/testUtils/ComparableContract$NamedPair;", "S", "", "", "a", "b", "name", "", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/String;)V", "getA", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "getB", "getName", "()Ljava/lang/String;", "TestUtils"})
    private static final class NamedPair<S extends Comparable<? super S>> {
        @NotNull
        private final S a;
        @NotNull
        private final S b;
        @NotNull
        private final String name;

        public NamedPair(@NotNull S a, @NotNull S b, @NotNull String name) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.a = a;
            this.b = b;
            this.name = name;
        }

        @NotNull
        public final S getA() {
            return this.a;
        }

        @NotNull
        public final S getB() {
            return this.b;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }
}

