/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class EqualsContract {
    static <T> void permutations(@NotNull List<T> items, @NotNull BiFunction<? super T, ? super T, ?> f) {
        for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                f.apply(items.get(i), items.get(j));
            }
        }
    }

    public static <S, T1 extends S, T2 extends S, T3 extends S, T4 extends S> void equalsHashCode(@NotNull T1 equiv1, @NotNull T2 equiv2, @NotNull T3 equiv3, @NotNull T4 different, boolean requireDistinctHashes) {
        if (equiv1 == equiv2 || equiv1 == equiv3 || equiv1 == different || equiv2 == equiv3 || equiv2 == different || equiv3 == different) {
            throw new IllegalArgumentException("You must provide four different (having different memory locations) but 3 equivalent objects");
        }
        List<Object> equivs = Arrays.asList(equiv1, equiv2, equiv3);
        Assert.assertFalse((String)"The different param should not allow itself to equal null", (boolean)different.equals(null));
        Assert.assertEquals((String)"The different param must have the same hashCode as itself", (long)different.hashCode(), (long)different.hashCode());
        Assert.assertTrue((String)"The different param must equal itself", (boolean)different.equals(different));
        int i = 0;
        for (Object equiv : equivs) {
            Assert.assertEquals((String)("Param " + ++i + " must have the same hashCode as itself"), (long)equiv.hashCode(), (long)equiv.hashCode());
            if (requireDistinctHashes) {
                Assert.assertNotEquals((String)("The hashCode of param " + i + " must not equal the hashCode of the different param.  If you meant to do that, use equalsSameHashCode() instead."), (long)equiv.hashCode(), (long)different.hashCode());
            } else {
                Assert.assertEquals((String)("The hashCode of param " + i + " must equal the hashCode of the different param  If you meant to do that, use equalsDistinctHashCode() instead."), (long)equiv.hashCode(), (long)different.hashCode());
            }
            Assert.assertTrue((String)("Param " + i + " must be equal to itself"), (boolean)equiv.equals(equiv));
            Assert.assertFalse((String)("Param " + i + " cannot be equal to the different param"), (boolean)equiv.equals(different));
            Assert.assertFalse((String)("The different param cannot be equal to param " + i), (boolean)different.equals(equiv));
            Assert.assertFalse((String)("Param " + i + " cannot allow itself to equal null"), (boolean)equiv.equals(null));
        }
        EqualsContract.permutations(equivs, (a, b) -> {
            Assert.assertEquals((String)("Found an unequal hashCode while inspecting permutations: a=" + a + " b=" + b), (long)a.hashCode(), (long)b.hashCode());
            Assert.assertTrue((String)("Failed equals while inspecting permutations: a=" + a + " b=" + b), (boolean)a.equals(b));
            Assert.assertTrue((String)"Failed reflexive equals while inspecting permutations", (boolean)b.equals(a));
            return null;
        });
    }

    public static <S, T1 extends S, T2 extends S, T3 extends S, T4 extends S> void equalsSameHashCode(@NotNull T1 equiv1, @NotNull T2 equiv2, @NotNull T3 equiv3, @NotNull T4 different) {
        EqualsContract.equalsHashCode(equiv1, equiv2, equiv3, different, false);
    }

    public static <S, T1 extends S, T2 extends S, T3 extends S, T4 extends S> void equalsDistinctHashCode(@NotNull T1 equiv1, @NotNull T2 equiv2, @NotNull T3 equiv3, @NotNull T4 different) {
        EqualsContract.equalsHashCode(equiv1, equiv2, equiv3, different, true);
    }
}

