/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.organicdesign.testUtils.ComparatorContract;
import org.organicdesign.testUtils.EqualsContract;

public class CompareToContract {
    private static <S extends Comparable<? super S>> void pairComp(@NotNull NamedPair<S> first, @NotNull ComparatorContract.CompToZero comp, @NotNull NamedPair<S> second) {
        Assert.assertTrue((String)("Item A in the " + first.name + " pair must be " + comp.english() + " item A in the " + second.name + " pair"), (boolean)comp.vsZero(first.a.compareTo(second.a)));
        Assert.assertTrue((String)("Item A in the " + first.name + " pair must be " + comp.english() + " item B in the " + second.name + " pair"), (boolean)comp.vsZero(first.a.compareTo(second.b)));
        Assert.assertTrue((String)("Item B in the " + first.name + " pair must be " + comp.english() + " item A in the " + second.name + " pair"), (boolean)comp.vsZero(first.b.compareTo(second.a)));
        Assert.assertTrue((String)("Item B in the " + first.name + " pair must be " + comp.english() + " item B in the " + second.name + " pair"), (boolean)comp.vsZero(first.b.compareTo(second.b)));
    }

    public static <S extends Comparable<? super S>> void testCompareTo(@NotNull S least1, @NotNull S least2, @NotNull S middle1, @NotNull S middle2, @NotNull S greatest1, @NotNull S greatest2) {
        AtomicBoolean anySame = new AtomicBoolean();
        EqualsContract.permutations(Arrays.asList(least1, least2, middle1, middle2, greatest1, greatest2), (a, b) -> {
            if (a == b) {
                anySame.set(true);
            }
            return null;
        });
        if (anySame.get()) {
            throw new IllegalArgumentException("You must provide three pair of different objects in order");
        }
        NamedPair<S> least = new NamedPair<S>(least1, least2, "Least");
        NamedPair<S> middle = new NamedPair<S>(middle1, middle2, "Middle");
        NamedPair<S> greatest = new NamedPair<S>(greatest1, greatest2, "Greatest");
        for (NamedPair comp : Arrays.asList(least, middle, greatest)) {
            CompareToContract.pairComp(comp, ComparatorContract.CompToZero.EQZ, comp);
            Assert.assertEquals((String)(comp.name + " A must be compatibly equal to its paired B element"), comp.a, comp.b);
            Assert.assertEquals((String)(comp.name + " B must be compatibly equal to its paired A element"), comp.b, comp.a);
        }
        int i = 0;
        for (Comparable comp : Arrays.asList(least1, least2, middle1, middle2, greatest1, greatest2)) {
            Assert.assertEquals((String)("item.equals(itself) should have return true for item " + ++i), (Object)comp, (Object)comp);
            try {
                comp.compareTo(null);
                Assert.fail((String)("e.compareTo(null) should throw a NullPointerException even though e.equals(null) returns false, but item " + i + "did not."));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            Assert.assertNotEquals((String)("item.equals(null) should always be false.  Item " + i + " failed"), null, (Object)comp);
        }
        CompareToContract.pairComp(least, ComparatorContract.CompToZero.LTZ, middle);
        CompareToContract.pairComp(least, ComparatorContract.CompToZero.LTZ, greatest);
        CompareToContract.pairComp(middle, ComparatorContract.CompToZero.LTZ, greatest);
        CompareToContract.pairComp(greatest, ComparatorContract.CompToZero.GTZ, middle);
        CompareToContract.pairComp(greatest, ComparatorContract.CompToZero.GTZ, least);
        CompareToContract.pairComp(middle, ComparatorContract.CompToZero.GTZ, least);
    }

    private static class NamedPair<S extends Comparable<? super S>> {
        @NotNull
        final S a;
        @NotNull
        final S b;
        @NotNull
        final String name;

        NamedPair(@NotNull S theA, @NotNull S theB, @NotNull String nm) {
            this.a = theA;
            this.b = theB;
            this.name = nm;
        }
    }
}

