/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils.http;

import javax.servlet.http.Cookie;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.indented.IndentedStringable;
import org.organicdesign.indented.StringUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/organicdesign/testUtils/http/CookiePrinter;", "Lorg/organicdesign/indented/IndentedStringable;", "cookie", "Ljavax/servlet/http/Cookie;", "(Ljavax/servlet/http/Cookie;)V", "indentedStr", "", "indent", "", "toString", "TestUtils"})
public final class CookiePrinter
implements IndentedStringable {
    private final Cookie cookie;

    @NotNull
    public String indentedStr(int indent) {
        String ret = "Cookie(" + StringUtils.stringify((String)this.cookie.getName()) + ", " + StringUtils.stringify((String)this.cookie.getValue());
        if (this.cookie.getDomain() != null) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "domain=" + StringUtils.stringify((String)this.cookie.getDomain());
        }
        if (this.cookie.getMaxAge() != -1) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "maxAge=" + this.cookie.getMaxAge();
        }
        if (this.cookie.getPath() != null) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "path=" + StringUtils.stringify((String)this.cookie.getPath());
        }
        if (this.cookie.getSecure()) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "secure";
        }
        if (this.cookie.getVersion() != 0) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "version=" + this.cookie.getVersion();
        }
        if (this.cookie.isHttpOnly()) {
            ret = ret + ",\n" + StringUtils.spaces((int)(indent + 7)) + "httpOnly";
        }
        return ret + ')';
    }

    @NotNull
    public String toString() {
        return this.indentedStr(0);
    }

    public CookiePrinter(@NotNull Cookie cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        this.cookie = cookie;
    }
}

