/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.organicdesign.testUtils.ComparatorContract;
import org.organicdesign.testUtils.EqualsContract;

public class CompareToContract {
    private static NamedPair t3(Comparable a, Comparable b, String c) {
        return new NamedPair(a, b, c);
    }

    private static void pairComp(NamedPair first, ComparatorContract.CompToZero comp, NamedPair second) {
        Assert.assertTrue((String)("Item A in the " + first.name + " pair must be " + comp.english() + " item A in the " + second.name + " pair"), (boolean)comp.vsZero(first.a.compareTo(second.a)));
        Assert.assertTrue((String)("Item A in the " + first.name + " pair must be " + comp.english() + " item B in the " + second.name + " pair"), (boolean)comp.vsZero(first.a.compareTo(second.b)));
        Assert.assertTrue((String)("Item B in the " + first.name + " pair must be " + comp.english() + " item A in the " + second.name + " pair"), (boolean)comp.vsZero(first.b.compareTo(second.a)));
        Assert.assertTrue((String)("Item B in the " + first.name + " pair must be " + comp.english() + " item B in the " + second.name + " pair"), (boolean)comp.vsZero(first.b.compareTo(second.b)));
    }

    public static <S extends Comparable<? super S>, T1 extends S, T2 extends S, T3 extends S> void testCompareTo(T1 least1, T1 least2, T2 middle1, T2 middle2, T3 greatest1, T3 greatest2) {
        AtomicBoolean anySame = new AtomicBoolean();
        EqualsContract.permutations(Arrays.asList(least1, least2, middle1, middle2, greatest1, greatest2), (a, b) -> {
            if (a == b) {
                anySame.set(true);
            }
            return null;
        });
        if (anySame.get()) {
            throw new IllegalArgumentException("You must provide three pair of different objects in order");
        }
        NamedPair least = CompareToContract.t3(least1, least2, "Least");
        NamedPair middle = CompareToContract.t3(middle1, middle2, "Middle");
        NamedPair greatest = CompareToContract.t3(greatest1, greatest2, "Greatest");
        for (NamedPair comp : Arrays.asList(least, middle, greatest)) {
            CompareToContract.pairComp(comp, ComparatorContract.CompToZero.EQZ, comp);
            Assert.assertEquals((String)(comp.name + " A must be compatibly equal to its paired B element"), (Object)comp.a, (Object)comp.b);
            Assert.assertEquals((String)(comp.name + " B must be compatibly equal to its paired A element"), (Object)comp.b, (Object)comp.a);
        }
        int i = 0;
        for (Comparable comp : Arrays.asList(least1, least2, middle1, middle2, greatest1, greatest2)) {
            Assert.assertEquals((String)("item.equals(itself) should have return true for item " + ++i), (Object)comp, (Object)comp);
            try {
                comp.compareTo(null);
                Assert.fail((String)("e.compareTo(null) should throw a NullPointerException even though e.equals(null) returns false, but item " + i + "did not."));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            Assert.assertNotEquals((String)("item.equals(null) should always be false.  Item " + i + " failed"), null, (Object)comp);
        }
        CompareToContract.pairComp(least, ComparatorContract.CompToZero.LTZ, middle);
        CompareToContract.pairComp(least, ComparatorContract.CompToZero.LTZ, greatest);
        CompareToContract.pairComp(middle, ComparatorContract.CompToZero.LTZ, greatest);
        CompareToContract.pairComp(greatest, ComparatorContract.CompToZero.GTZ, middle);
        CompareToContract.pairComp(greatest, ComparatorContract.CompToZero.GTZ, least);
        CompareToContract.pairComp(middle, ComparatorContract.CompToZero.GTZ, least);
    }

    private static class NamedPair {
        final Comparable a;
        final Comparable b;
        final String name;

        NamedPair(Comparable theA, Comparable theB, String nm) {
            this.a = theA;
            this.b = theB;
            this.name = nm;
        }
    }
}

