/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.testUtils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.organicdesign.testUtils.EqualsContract;

public class ComparatorContract {
    private static <T> Named<T> t2(T a, String c) {
        return new Named<T>(a, c);
    }

    private static <T> void pairComp(Named<T> first, CompToZero comp, Named<T> second, Comparator<T> comparator) {
        Assert.assertTrue((String)("The " + first.name + " item must be " + comp.english() + " the " + second.name), (boolean)comp.vsZero(comparator.compare(first.a, second.a)));
    }

    public static <T> void testComparator(T least1, T middle1, T greatest1, Comparator<T> comparator) {
        AtomicBoolean anySame = new AtomicBoolean();
        EqualsContract.permutations(Arrays.asList(least1, middle1, greatest1), (a, b) -> {
            if (a == b) {
                anySame.set(true);
            }
            return null;
        });
        if (anySame.get()) {
            throw new IllegalArgumentException("You must provide three pair of different objects in order");
        }
        int i = 0;
        for (Object item : Arrays.asList(least1, middle1, greatest1)) {
            ++i;
            try {
                comparator.compare(item, null);
                Assert.fail((String)("comparator.compare(item, null) should throw an exception even though e.equals(null) returns false, but item " + i + " did not."));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                comparator.compare(null, item);
                Assert.fail((String)("comparator.compare(null, item) should throw an exception even though e.equals(null) returns false, but item " + i + " did not."));
            }
            catch (RuntimeException runtimeException) {}
        }
        Named<T> least = ComparatorContract.t2(least1, "Least");
        Named<T> middle = ComparatorContract.t2(middle1, "Middle");
        Named<T> greatest = ComparatorContract.t2(greatest1, "Greatest");
        for (Named pair : Arrays.asList(least, middle, greatest)) {
            ComparatorContract.pairComp(pair, CompToZero.EQZ, pair, comparator);
        }
        ComparatorContract.pairComp(least, CompToZero.LTZ, middle, comparator);
        ComparatorContract.pairComp(least, CompToZero.LTZ, greatest, comparator);
        ComparatorContract.pairComp(middle, CompToZero.LTZ, greatest, comparator);
        ComparatorContract.pairComp(greatest, CompToZero.GTZ, middle, comparator);
        ComparatorContract.pairComp(greatest, CompToZero.GTZ, least, comparator);
        ComparatorContract.pairComp(middle, CompToZero.GTZ, least, comparator);
    }

    private static class Named<T> {
        final T a;
        final String name;

        Named(T theA, String nm) {
            this.a = theA;
            this.name = nm;
        }
    }

    public static enum CompToZero {
        LTZ{

            @Override
            public String english() {
                return "less than";
            }

            @Override
            public boolean vsZero(int i) {
                return i < 0;
            }
        }
        ,
        GTZ{

            @Override
            public String english() {
                return "greater than";
            }

            @Override
            public boolean vsZero(int i) {
                return i > 0;
            }
        }
        ,
        EQZ{

            @Override
            public String english() {
                return "equal to";
            }

            @Override
            public boolean vsZero(int i) {
                return i == 0;
            }
        };


        public abstract String english();

        public abstract boolean vsZero(int var1);
    }
}

