/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.validation.asset.AllKieProjectFilesFilter;
import org.kie.workbench.common.services.backend.validation.asset.Filter;
import org.kie.workbench.common.services.backend.validation.asset.NoProjectException;
import org.kie.workbench.common.services.backend.validation.asset.Validator;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorFileSystemProvider;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.optaplanner.core.api.solver.SolverFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;

public class SolverValidator {
    private IOService ioService;
    private KieProjectService projectService;
    @Inject
    private LRUBuilderCache builderCache;

    public SolverValidator() {
    }

    @Inject
    public SolverValidator(@Named(value="ioStrategy") IOService ioService, KieProjectService projectService) {
        this.ioService = ioService;
        this.projectService = projectService;
    }

    public List<ValidationMessage> validate(Path resourcePath, String content) {
        try {
            org.kie.workbench.common.services.shared.project.KieProject kieProject = (org.kie.workbench.common.services.shared.project.KieProject)this.projectService.resolveProject(resourcePath);
            Validator validator = this.getValidator(resourcePath, content, kieProject);
            List validationMessages = validator.validate();
            if (validationMessages.isEmpty()) {
                return this.buildSolver(resourcePath, kieProject, validator);
            }
            return validationMessages;
        }
        catch (NoProjectException e) {
            return new ArrayList<ValidationMessage>();
        }
    }

    private List<ValidationMessage> buildSolver(Path resourcePath, org.kie.workbench.common.services.shared.project.KieProject kieProject, Validator validator) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        ValidationMessage validationMessage = this.createSolverFactory(resourcePath, validator, kieProject);
        if (validationMessage != null) {
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    private Validator getValidator(Path resourcePath, String content, org.kie.workbench.common.services.shared.project.KieProject kieProject) throws NoProjectException {
        return new Validator(new ValidatorFileSystemProvider(resourcePath, (InputStream)new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)), kieProject, this.ioService, (Filter)new AllKieProjectFilesFilter(new DirectoryStream.Filter[0]))){

            protected void addMessage(String destinationBasePath, Message message) {
                this.validationMessages.add(this.convertMessage(message));
            }
        };
    }

    private ValidationMessage createSolverFactory(Path resourcePath, Validator validator, org.kie.workbench.common.services.shared.project.KieProject kieWorkbenchProject) {
        KieModuleKieProject kieProject = new KieModuleKieProject((InternalKieModule)validator.getKieBuilder().getKieModule(), null);
        KieContainerImpl kieContainer = new KieContainerImpl((KieProject)kieProject, KieServices.Factory.get().getRepository());
        try {
            String solverConfigResource = this.getSolverConfigResource(resourcePath, kieWorkbenchProject);
            SolverFactory.createFromKieContainerXmlResource((KieContainer)kieContainer, (String)solverConfigResource).buildSolver();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.make(e, resourcePath);
        }
        return null;
    }

    private String getSolverConfigResource(Path resourcePath, org.kie.workbench.common.services.shared.project.KieProject kieWorkbenchProject) {
        return resourcePath.toURI().substring(kieWorkbenchProject.getRootPath().toURI().length() + "/src/main/resources/".length());
    }

    private ValidationMessage make(Exception e, Path resourcePath) {
        ValidationMessage message = new ValidationMessage();
        message.setId(0L);
        message.setLevel(Level.ERROR);
        message.setPath(resourcePath);
        message.setText(e.getMessage());
        return message;
    }
}

