/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.XStreamXmlSolverFactory;
import org.optaplanner.workbench.screens.solver.model.ScoreDefinitionTypeModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.uberfire.io.IOService;

public class ConfigPersistence {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private final XStream xStream = XStreamXmlSolverFactory.buildXStream();

    public SolverConfigModel toConfig(String xml) {
        SolverConfig solverConfig = this.toSolverConfig(xml);
        SolverConfigModel model = new SolverConfigModel();
        model.setTerminationConfig(this.create(solverConfig.getTerminationConfig()));
        model.setScoreDirectorFactoryConfig(this.create(solverConfig.getScoreDirectorFactoryConfig()));
        return model;
    }

    public SolverConfig toSolverConfig(String xml) {
        return (SolverConfig)this.xStream.fromXML(xml);
    }

    private ScoreDirectorFactoryConfigModel create(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        if (scoreDirectorFactoryConfig == null) {
            return model;
        }
        model.setScoreDefinitionType(this.create(scoreDirectorFactoryConfig.getScoreDefinitionType()));
        model.setScoreDrlList(scoreDirectorFactoryConfig.getScoreDrlList());
        return model;
    }

    private ScoreDefinitionTypeModel create(ScoreDefinitionType scoreDefinitionType) {
        if (scoreDefinitionType != null) {
            for (ScoreDefinitionTypeModel model : ScoreDefinitionTypeModel.values()) {
                if (!model.name().equals(scoreDefinitionType.name())) continue;
                return model;
            }
        }
        return null;
    }

    private TerminationConfigModel create(TerminationConfig terminationConfig) {
        TerminationConfigModel model = new TerminationConfigModel();
        if (terminationConfig == null) {
            return model;
        }
        model.setDaysSpentLimit(terminationConfig.getDaysSpentLimit());
        model.setHoursSpentLimit(terminationConfig.getHoursSpentLimit());
        model.setMinutesSpentLimit(terminationConfig.getMinutesSpentLimit());
        model.setSecondsSpentLimit(terminationConfig.getSecondsSpentLimit());
        model.setMillisecondsSpentLimit(terminationConfig.getMillisecondsSpentLimit());
        model.setUnimprovedDaysSpentLimit(terminationConfig.getUnimprovedDaysSpentLimit());
        model.setUnimprovedHoursSpentLimit(terminationConfig.getUnimprovedHoursSpentLimit());
        model.setUnimprovedMinutesSpentLimit(terminationConfig.getUnimprovedMinutesSpentLimit());
        model.setUnimprovedSecondsSpentLimit(terminationConfig.getUnimprovedSecondsSpentLimit());
        model.setUnimprovedMillisecondsSpentLimit(terminationConfig.getUnimprovedMillisecondsSpentLimit());
        return model;
    }

    public String toXML(SolverConfigModel config) {
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setScanAnnotatedClassesConfig(new ScanAnnotatedClassesConfig());
        solverConfig.setTerminationConfig(this.create(config.getTermination()));
        solverConfig.setScoreDirectorFactoryConfig(this.create(config.getScoreDirectorFactoryConfig()));
        return this.xStream.toXML((Object)solverConfig);
    }

    private ScoreDirectorFactoryConfig create(ScoreDirectorFactoryConfigModel scoreDirectorFactoryConfig) {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig();
        if (scoreDirectorFactoryConfig == null) {
            return config;
        }
        config.setScoreDefinitionType(this.create(scoreDirectorFactoryConfig.getScoreDefinitionType()));
        config.setScoreDrlList(scoreDirectorFactoryConfig.getScoreDrlList());
        return config;
    }

    private ScoreDefinitionType create(ScoreDefinitionTypeModel scoreDefinitionType) {
        if (scoreDefinitionType != null) {
            for (ScoreDefinitionType model : ScoreDefinitionType.values()) {
                if (!model.name().equals(scoreDefinitionType.name())) continue;
                return model;
            }
        }
        return null;
    }

    private TerminationConfig create(TerminationConfigModel termination) {
        TerminationConfig terminationConfig = new TerminationConfig();
        if (termination == null) {
            return terminationConfig;
        }
        terminationConfig.setDaysSpentLimit(termination.getDaysSpentLimit());
        terminationConfig.setHoursSpentLimit(termination.getHoursSpentLimit());
        terminationConfig.setMinutesSpentLimit(termination.getMinutesSpentLimit());
        terminationConfig.setSecondsSpentLimit(termination.getSecondsSpentLimit());
        terminationConfig.setMillisecondsSpentLimit(termination.getMillisecondsSpentLimit());
        terminationConfig.setUnimprovedDaysSpentLimit(termination.getUnimprovedDaysSpentLimit());
        terminationConfig.setUnimprovedHoursSpentLimit(termination.getUnimprovedHoursSpentLimit());
        terminationConfig.setUnimprovedMinutesSpentLimit(termination.getUnimprovedMinutesSpentLimit());
        terminationConfig.setUnimprovedSecondsSpentLimit(termination.getUnimprovedSecondsSpentLimit());
        terminationConfig.setUnimprovedMillisecondsSpentLimit(termination.getUnimprovedMillisecondsSpentLimit());
        return terminationConfig;
    }
}

