/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import java.util.List;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.workbench.screens.solver.backend.server.ConfigPersistence;
import org.optaplanner.workbench.screens.solver.backend.server.SolverValidator;
import org.optaplanner.workbench.screens.solver.backend.server.TestUtil;

@RunWith(value=MockitoJUnitRunner.class)
public class SolverValidatorTest {
    @Spy
    ConfigPersistence configPersistence = new ConfigPersistence();
    @InjectMocks
    SolverValidator solverValidator;

    @Test
    public void testMissingSolutionClass() throws Exception {
        List result = this.solverValidator.validate("<solver />");
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"The solver configuration must have a solutionClass (null), if it has no scanAnnotatedClasses (null).", (Object)((ValidationMessage)result.get(0)).getText());
    }

    @Test
    public void testFromFile() throws Exception {
        List result = this.solverValidator.validate(TestUtil.loadResource("solver.xml"));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"The scanAnnotatedClasses (ScanAnnotatedClassesConfig()) did not find any classes with a PlanningSolution annotation.", (Object)((ValidationMessage)result.get(0)).getText());
    }
}

