/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionSimpleConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.SimpleConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.TestUtils;

public class SimpleConstraintMatchPersistenceExtensionTest {
    private SimpleConstraintMatchPersistenceExtension extension = new SimpleConstraintMatchPersistenceExtension();
    private TestUtils testUtils = new TestUtils((RuleModelIActionPersistenceExtension)this.extension);

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addConstraintMatch(kcontext, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalSimpleConstraintMatchNull() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addConstraintMatch(kcontext, null);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSimpleConstraintMatch));
        ActionSimpleConstraintMatch actionSimpleConstraintMatch = (ActionSimpleConstraintMatch)action;
        Assert.assertNull((Object)actionSimpleConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalSimpleConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addConstraintMatch(kcontext, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSimpleConstraintMatch));
        ActionSimpleConstraintMatch actionSimpleConstraintMatch = (ActionSimpleConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionSimpleConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        String actionText = "unrecognizedString";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("unrecognizedString");
    }

    @Test
    public void unmarshalTooManyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch(kcontext, -1, 123);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch(kcontext, -1, 123);");
    }

    @Test
    public void unmarshalNotEnoughArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch(kcontext);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch(kcontext);");
    }

    @Test
    public void unmarshalEmptyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch( , );";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch( , );");
    }

    @Test
    public void unmarshalMissingArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch();";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch();");
    }

    @Test
    public void unmarshalWrongFirstArgument() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch(context, 1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch(context, 1);");
    }

    @Test
    public void unmarshalWrongFirstAndTooMuchArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addConstraintMatch(context, 1, -1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addConstraintMatch(context, 1, -1);");
    }
}

