/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.MultiConstraintHardSoftMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.TestUtils;

public class MultiConstraintMatchPersistenceExtensionTest {
    private MultiConstraintHardSoftMatchPersistenceExtension extension = new MultiConstraintHardSoftMatchPersistenceExtension();
    private TestUtils testUtils = new TestUtils((RuleModelIActionPersistenceExtension)this.extension);

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalActionMultiConstraintHardSoftMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardSoftMatch));
        ActionMultiConstraintHardSoftMatch actionActionMultiConstraintHardSoftMatch = (ActionMultiConstraintHardSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintHardSoftMatchNull() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, null, null);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardSoftMatch));
        ActionMultiConstraintHardSoftMatch actionActionMultiConstraintHardSoftMatch = (ActionMultiConstraintHardSoftMatch)action;
        Assert.assertNull((Object)actionActionMultiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertNull((Object)actionActionMultiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintHardMediumSoftMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardMediumSoftMatch));
        ActionMultiConstraintHardMediumSoftMatch actionActionMultiConstraintHardMediumSoftMatch = (ActionMultiConstraintHardMediumSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionMediumConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-3", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintBendableMatchDifferentLength() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, new int[] {2, -3});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, new int[] {2, -3});");
        List<ActionBendableHardConstraintMatch> hardConstraintList = Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"));
        List<ActionBendableSoftConstraintMatch> softConstraintList = Arrays.asList(new ActionBendableSoftConstraintMatch(0, "2"), new ActionBendableSoftConstraintMatch(1, "-3"));
        ActionMultiConstraintBendableMatch expectedAction = new ActionMultiConstraintBendableMatch(hardConstraintList, softConstraintList);
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableMatchEmpty() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {}, new int[] {});";
        PluggableIAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableMatch expectedAction = new ActionMultiConstraintBendableMatch(Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});");
        List<ActionBendableHardConstraintMatch> hardConstraintList = Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"), new ActionBendableHardConstraintMatch(1, "-2"));
        List<ActionBendableSoftConstraintMatch> softConstraintList = Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3"), new ActionBendableSoftConstraintMatch(1, "-4"));
        ActionMultiConstraintBendableMatch expectedAction = new ActionMultiConstraintBendableMatch(hardConstraintList, softConstraintList);
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableLongMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});");
        List<ActionBendableHardConstraintMatch> hardConstraintList = Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1l"), new ActionBendableHardConstraintMatch(1, "-2l"));
        List<ActionBendableSoftConstraintMatch> softConstraintList = Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3l"), new ActionBendableSoftConstraintMatch(1, "-4l"));
        ActionMultiConstraintBendableLongMatch expectedAction = new ActionMultiConstraintBendableLongMatch(hardConstraintList, softConstraintList);
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableBigDecimalMatch() throws RuleModelDRLPersistenceException {
        String hard = "new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}";
        String soft = "new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)}";
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});");
        List<ActionBendableHardConstraintMatch> hardConstraintList = Arrays.asList(new ActionBendableHardConstraintMatch(0, "new java.math.BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new java.math.BigDecimal(-2)"));
        List<ActionBendableSoftConstraintMatch> softConstraintList = Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new java.math.BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new java.math.BigDecimal(-4)"));
        ActionMultiConstraintBendableBigDecimalMatch expectedAction = new ActionMultiConstraintBendableBigDecimalMatch(hardConstraintList, softConstraintList);
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableBigDecimalMatch2() throws RuleModelDRLPersistenceException {
        String hardConstraint = "new BigDecimal[] {new BigDecimal(-1), new BigDecimal(-2)}";
        String softConstraint = "new BigDecimal[] {new BigDecimal(-3), new BigDecimal(-4)}";
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new BigDecimal[] {new BigDecimal(-1), new BigDecimal(-2)}, new BigDecimal[] {new BigDecimal(-3), new BigDecimal(-4)});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new BigDecimal[] {new BigDecimal(-1), new BigDecimal(-2)}, new BigDecimal[] {new BigDecimal(-3), new BigDecimal(-4)});");
        List<ActionBendableHardConstraintMatch> hardConstraintList = Arrays.asList(new ActionBendableHardConstraintMatch(0, "new BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new BigDecimal(-2)"));
        List<ActionBendableSoftConstraintMatch> softConstraintList = Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new BigDecimal(-4)"));
        ActionMultiConstraintBendableBigDecimalMatch expectedAction = new ActionMultiConstraintBendableBigDecimalMatch(hardConstraintList, softConstraintList);
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintHardSoftMatchArrays() throws RuleModelDRLPersistenceException {
        String hardConstraint = "new float[] {-1}";
        String softConstraint = "new float[] {-2}";
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new float[] {-1}, new float[] {-2});";
        PluggableIAction action = this.extension.unmarshal("scoreHolder.addMultiConstraintMatch(kcontext, new float[] {-1}, new float[] {-2});");
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardSoftMatch));
        ActionMultiConstraintHardSoftMatch actionActionMultiConstraintHardSoftMatch = (ActionMultiConstraintHardSoftMatch)action;
        Assert.assertEquals((Object)"new float[] {-1}", (Object)actionActionMultiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"new float[] {-2}", (Object)actionActionMultiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        String actionText = "unrecognizedString";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("unrecognizedString");
    }

    @Test
    public void unmarshalTooManyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3, 123);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3, 123);");
    }

    @Test
    public void unmarshalNotEnoughArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext, -1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext, -1);");
    }

    @Test
    public void unmarshalNotEnoughArgumentsJustOne() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext);");
    }

    @Test
    public void unmarshalMissingArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch();";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch();");
    }

    @Test
    public void unmarshalEmptyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch( , , );";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch( , , );");
    }

    @Test
    public void unmarshalWrongFirstArgument() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(context, 1, -1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(context, 1, -1);");
    }

    @Test
    public void unmarshalWrongFirstArgumentHardMediumSoft() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(context, 1, -1, 1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(context, 1, -1, 1);");
    }

    @Test
    public void unmarshalWrongFirstArgumentArrays() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(context, new long[] {-1}, new long[] {-2});";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(context, new long[] {-1}, new long[] {-2});");
    }

    @Test
    public void unmarshalDifferentArrays() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, new long[] {-2});";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, new long[] {-2});");
    }

    @Test
    public void unmarshalHardIsArraySoftIsNot() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, -2);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1}, -2);");
    }

    @Test
    public void unmarshalHardIsNotArraySoftIs() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMultiConstraintMatch(kcontext, -1, new long[] {-2});";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMultiConstraintMatch(kcontext, -1, new long[] {-2});");
    }
}

