/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;

public class PersistenceExtensionUtilsTest {
    @Test
    public void testUnwrapWhenNothingToDo() throws Exception {
        String constantToUnwrap = "abc";
        Assert.assertEquals((Object)"abc", (Object)PersistenceExtensionUtils.unwrapParenthesis((String)"abc"));
        Assert.assertEquals((Object)"abc", (Object)PersistenceExtensionUtils.unwrapCurlyBrackets((String)"abc"));
    }

    @Test
    public void testUnwrapMissingEnd() throws Exception {
        String constantToUnwrapOne = "(abc";
        String constantToUnwrapTwo = "{abc";
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapParenthesis((String)"(abc")).hasMessage("\"(abc\" had not characters '(':0 and ')':-1 in appropriate order.");
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapCurlyBrackets((String)"{abc")).hasMessage("\"{abc\" had not characters '{':0 and '}':-1 in appropriate order.");
    }

    @Test
    public void testUnwrapMissingStart() throws Exception {
        String constantToUnwrapOne = "abc)";
        String constantToUnwrapTwo = "abc}";
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapParenthesis((String)"abc)")).hasMessage("\"abc)\" had not characters '(':-1 and ')':3 in appropriate order.");
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapCurlyBrackets((String)"abc}")).hasMessage("\"abc}\" had not characters '{':-1 and '}':3 in appropriate order.");
    }

    @Test
    public void testUnwrapMissingWrongOrder() throws Exception {
        String constant = ")abc(";
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapParenthesis((String)")abc(")).hasMessage("\")abc(\" had not characters '(':4 and ')':0 in appropriate order.");
    }

    @Test
    public void testUnwrapMissingWrongOrderCurly() throws Exception {
        String constant = "}abc{";
        Assertions.assertThatThrownBy(() -> PersistenceExtensionUtils.unwrapCurlyBrackets((String)"}abc{")).hasMessage("\"}abc{\" had not characters '{':4 and '}':0 in appropriate order.");
    }
}

