/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.api.score;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.persistence.jackson.api.AbstractJacksonRoundTripTest;

public abstract class AbstractScoreJacksonRoundTripTest
extends AbstractJacksonRoundTripTest {
    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserialize(Score_ expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            jsonString = objectMapper.writeValueAsString(input);
            output = (TestScoreWrapper)objectMapper.readValue(jsonString, input.getClass());
        }
        catch (IOException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        String regex = expectedScore != null ? "\\{\\s*\"score\":\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\s*\\}" : "\\{\"score\":null\\}";
        if (!jsonString.matches(regex)) {
            Assertions.fail((String)("Regular expression match failed.\nExpected regular expression: " + regex + "\nActual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<Score_ extends Score<Score_>> {
        public abstract Score_ getScore();
    }
}

