/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.api;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.persistence.jackson.api.AbstractJacksonJsonSerializerAndDeserializerTest;
import org.optaplanner.persistence.jackson.api.OptaPlannerJacksonModule;

public class OptaPlannerJacksonModuleTest
extends AbstractJacksonJsonSerializerAndDeserializerTest {
    @Test
    public void polymorphicScore() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        objectMapper.registerModule(OptaPlannerJacksonModule.createModule());
        TestOptaPlannerJacksonModuleWrapper input = new TestOptaPlannerJacksonModuleWrapper();
        input.setBendableScore(BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}));
        input.setHardSoftScore(HardSoftScore.of((int)-1, (int)-20));
        input.setPolymorphicScore((Score)HardSoftScore.of((int)-20, (int)-300));
        TestOptaPlannerJacksonModuleWrapper output = OptaPlannerJacksonModuleTest.serializeAndDeserialize(objectMapper, input);
        Assert.assertEquals((Object)BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}), (Object)output.getBendableScore());
        Assert.assertEquals((Object)HardSoftScore.of((int)-1, (int)-20), (Object)output.getHardSoftScore());
        Assert.assertEquals((Object)HardSoftScore.of((int)-20, (int)-300), (Object)output.getPolymorphicScore());
        input.setPolymorphicScore((Score)BendableScore.of((int[])new int[]{-1, -20}, (int[])new int[]{-300, -4000, -50000}));
        output = OptaPlannerJacksonModuleTest.serializeAndDeserialize(objectMapper, input);
        Assert.assertEquals((Object)BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}), (Object)output.getBendableScore());
        Assert.assertEquals((Object)HardSoftScore.of((int)-1, (int)-20), (Object)output.getHardSoftScore());
        Assert.assertEquals((Object)BendableScore.of((int[])new int[]{-1, -20}, (int[])new int[]{-300, -4000, -50000}), (Object)output.getPolymorphicScore());
    }

    public static class TestOptaPlannerJacksonModuleWrapper {
        private BendableScore bendableScore;
        private HardSoftScore hardSoftScore;
        private Score polymorphicScore;

        private TestOptaPlannerJacksonModuleWrapper() {
        }

        public BendableScore getBendableScore() {
            return this.bendableScore;
        }

        public void setBendableScore(BendableScore bendableScore) {
            this.bendableScore = bendableScore;
        }

        public HardSoftScore getHardSoftScore() {
            return this.hardSoftScore;
        }

        public void setHardSoftScore(HardSoftScore hardSoftScore) {
            this.hardSoftScore = hardSoftScore;
        }

        public Score getPolymorphicScore() {
            return this.polymorphicScore;
        }

        public void setPolymorphicScore(Score polymorphicScore) {
            this.polymorphicScore = polymorphicScore;
        }
    }
}

