/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.zoomBox;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import ptolemy.plot.PlotBox;
import ptolemy.plot.zoomBox.ZoomIcon;
import ptolemy.plot.zoomBox.ZoomIcons;

public class ZoomRectangle {
    private boolean valid = false;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private boolean showFancyIcon = true;
    private final PlotBox plotBox;
    private final int signLength = 6;
    private final int signMiddle = 3;
    private final int signBorder = 3;
    private static final BasicStroke lineStroke1 = new BasicStroke(2.0f, 0, 1);

    public ZoomRectangle(PlotBox plotBox) {
        this(plotBox, 0, 0);
    }

    public ZoomRectangle(PlotBox plotBox, int x1, int y1) {
        this.plotBox = plotBox;
        if (x1 > plotBox.get_lrx()) {
            x1 = plotBox.get_lrx();
        }
        if (x1 < plotBox.get_ulx()) {
            x1 = plotBox.get_ulx();
        }
        this.x1 = x1;
        if (y1 > plotBox.get_lry()) {
            y1 = plotBox.get_lry();
        }
        if (y1 < plotBox.get_uly()) {
            y1 = plotBox.get_uly();
        }
        this.y1 = y1;
    }

    public boolean isZoomingIn() {
        return this.x2 > this.x1 && this.y2 > this.y1;
    }

    public boolean isZoomingOut() {
        return this.x2 < this.x1 && this.y2 < this.y1;
    }

    public int getX1() {
        return this.x1;
    }

    public void setX1(int x1) {
        if (x1 > this.plotBox.get_lrx()) {
            x1 = this.plotBox.get_lrx();
        }
        if (x1 < this.plotBox.get_ulx()) {
            x1 = this.plotBox.get_ulx();
        }
        this.x1 = x1;
    }

    public void setEnd(int x2, int y2) {
        this.setX2(x2);
        this.setY2(y2);
        this.setValid();
    }

    public int getX2() {
        return this.x2;
    }

    public void setX2(int x2) {
        if (x2 > this.plotBox.get_lrx()) {
            x2 = this.plotBox.get_lrx();
        }
        if (x2 < this.plotBox.get_ulx()) {
            x2 = this.plotBox.get_ulx();
        }
        this.x2 = x2;
    }

    public int getY1() {
        return this.y1;
    }

    public void setY1(int y1) {
        if (y1 > this.plotBox.get_lry()) {
            y1 = this.plotBox.get_lry();
        }
        if (y1 < this.plotBox.get_uly()) {
            y1 = this.plotBox.get_uly();
        }
        this.y1 = y1;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY2(int y2) {
        if (y2 > this.plotBox.get_lry()) {
            y2 = this.plotBox.get_lry();
        }
        if (y2 < this.plotBox.get_uly()) {
            y2 = this.plotBox.get_uly();
        }
        this.y2 = y2;
    }

    protected void setValid() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void paintZoomRectangle(Component component, Graphics graphics) {
        if (this.isValid()) {
            Color save = graphics.getColor();
            graphics.setColor(Color.DARK_GRAY);
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(lineStroke1);
            }
            if (this.isZoomingIn()) {
                this.paintZoomingInRectangle(component, graphics);
            } else if (this.isZoomingOut()) {
                this.paintZoomingOutRectangle(component, graphics);
            }
            graphics.setColor(save);
        }
    }

    protected void paintZoomingInRectangle(Component component, Graphics graphics) {
        graphics.drawRect(this.getX1(), this.getY1(), this.getX2() - this.getX1(), this.getY2() - this.getY1());
        if (this.isShowingFancyIcons()) {
            this.drawZoomInIcon(component, graphics);
        } else {
            graphics.drawLine(this.getX2() - 6 - 3, this.getY1() + 3 + 3, this.getX2() - 3, this.getY1() + 3 + 3);
            graphics.drawLine(this.getX2() - 3 - 3, this.getY1() + 3, this.getX2() - 3 - 3, this.getY1() + 3 + 6);
        }
    }

    protected void paintZoomingOutRectangle(Component component, Graphics graphics) {
        graphics.drawRect(this.getX2(), this.getY2(), this.getX1() - this.getX2(), this.getY1() - this.getY2());
        int innerBoxWidth = 5;
        graphics.drawRect(this.getX2() + (this.getX1() - this.getX2()) / 2 - innerBoxWidth, this.getY2() + (this.getY1() - this.getY2()) / 2 - innerBoxWidth, 2 * innerBoxWidth, 2 * innerBoxWidth);
        if (this.isShowingFancyIcons()) {
            this.drawZoomOutIcon(component, graphics);
        } else {
            graphics.drawLine(this.getX1() - 6 - 3, this.getY2() + 3 + 3, this.getX1() - 3, this.getY2() + 3 + 3);
        }
    }

    protected void drawZoomInIcon(Component component, Graphics graphics) {
        ZoomIcon i = ZoomIcons.getIcon("icons/view-zoom-in.png");
        i.paintIcon(component, graphics, this.getX2() + i.getHorizontalOffset(), this.getY1() + i.getVerticalOffset());
    }

    protected void drawZoomOutIcon(Component component, Graphics graphics) {
        ZoomIcon i = ZoomIcons.getIcon("icons/view-zoom-out.png");
        i.paintIcon(component, graphics, this.getX1() + i.getHorizontalOffset(), this.getY2() + i.getVerticalOffset());
    }

    public void setShowFancyIcons(boolean showFancyIcon) {
        this.showFancyIcon = showFancyIcon;
    }

    public boolean isShowingFancyIcons() {
        return this.showFancyIcon;
    }
}

