/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import org.opt4j.core.config.annotations.Icon;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.start.Constant;
import org.opt4j.core.start.Opt4J;
import org.opt4j.core.start.Progress;
import org.opt4j.viewer.ControlButtons;
import org.opt4j.viewer.ControlToolBarService;
import org.opt4j.viewer.ConvergencePlotData;
import org.opt4j.viewer.StatusBar;
import org.opt4j.viewer.Viewer;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.ViewsToolBarService;
import org.opt4j.viewer.VisualizationModule;
import ptolemy.plot.DefaultFonts;

@Icon(value="icons/appl.png")
@Info(value="A graphical viewer to observe the optimization process.")
public class ViewerModule
extends VisualizationModule {
    @Info(value="The title of the viewer frame.")
    @Constant(value="title", namespace=Viewer.class)
    protected String title = "Opt4J " + Opt4J.getVersion() + " Viewer";
    @Info(value="Event for the optimization process if the viewer is closed.")
    @Constant(value="closeEvent", namespace=Viewer.class)
    protected Viewer.CloseEvent closeEvent = Viewer.CloseEvent.STOP;
    @Info(value="Close viewer automatically when the optimization process stops.")
    @Constant(value="closeOnStop", namespace=Viewer.class)
    protected boolean closeOnStop = false;

    public boolean isCloseOnStop() {
        return this.closeOnStop;
    }

    public void setCloseOnStop(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
    }

    public Viewer.CloseEvent getCloseEvent() {
        return this.closeEvent;
    }

    public void setCloseEvent(Viewer.CloseEvent closeEvent) {
        this.closeEvent = closeEvent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void config() {
        this.bind(Viewer.class).in(SINGLETON);
        this.addOptimizerStateListener(Viewer.class);
        this.bind(StatusBar.class).in(SINGLETON);
        this.addOptimizerStateListener(StatusBar.class);
        this.addOptimizerIterationListener(StatusBar.class);
        this.bind(Viewport.class).in(SINGLETON);
        this.addOptimizerIterationListener(Progress.class);
        this.addOptimizerStateListener(ControlButtons.class);
        this.addOptimizerIterationListener(ConvergencePlotData.class);
        this.addToolBarService(ControlToolBarService.class);
        this.addToolBarService(ViewsToolBarService.class);
    }

    static {
        if (DefaultFonts.LABElFONT == null) {
            throw new IllegalStateException();
        }
    }
}

