/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import org.opt4j.core.Objective;
import org.opt4j.core.config.visualization.DelayTask;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.viewer.AutoZoomButton;
import org.opt4j.viewer.ConvergencePlotData;
import org.opt4j.viewer.ObjectivesMonitor;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;
import ptolemy.plot.Plot;

@WidgetParameters(title="Convergence Plot", icon="icons/convergence.png")
public class ConvergencePlotWidget
implements Widget,
OptimizerIterationListener,
ObjectivesMonitor.ObjectivesListener {
    protected final DelayTask task = new DelayTask(40L);
    protected final ConvergencePlotData data;
    protected final Selection selection;
    protected final JPanel panel;
    protected final Plot plot;

    @Inject
    public ConvergencePlotWidget(Optimizer optimizer, ConvergencePlotData data, ObjectivesMonitor objectivesMonitor, AutoZoomButton autoZoom) {
        this.data = data;
        this.selection = new Selection();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.plot = new Plot();
        this.plot.addLegend(0, "Max");
        this.plot.addLegend(1, "Mean");
        this.plot.addLegend(2, "Min");
        Color[] colors = new Color[]{Color.RED, Color.LIGHT_GRAY, Color.BLUE};
        this.plot.setColors(colors);
        this.panel.add(this.plot);
        JToolBar menu = new JToolBar();
        menu.setFloatable(false);
        menu.add(this.selection);
        menu.addSeparator();
        autoZoom.setPlotBox(this.plot);
        menu.add(autoZoom);
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, menu.getBackground().darker());
        menu.setBorder(border);
        this.panel.add((Component)menu, "North");
        optimizer.addOptimizerIterationListener((OptimizerIterationListener)this);
        objectivesMonitor.addListener(this);
        this.doPaint();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void init(Viewport viewport) {
    }

    public void iterationComplete(int iteration) {
        this.doPaint();
    }

    protected void doPaint() {
        this.task.execute(new Runnable(){

            @Override
            public void run() {
                ConvergencePlotWidget.this.paint();
            }
        });
    }

    protected void paint() {
        final Objective objective = this.selection.getSelected();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvergencePlotWidget.this.plot.clear(false);
                ConvergencePlotWidget.this.plot.setXLabel("iteration");
                if (objective != null) {
                    ConvergencePlotWidget.this.plot.setYLabel(objective.getName());
                    ConvergencePlotWidget.this.paintList(ConvergencePlotWidget.this.data.getMaxPoints(objective), 0);
                    ConvergencePlotWidget.this.paintList(ConvergencePlotWidget.this.data.getMeanPoints(objective), 1);
                    ConvergencePlotWidget.this.paintList(ConvergencePlotWidget.this.data.getMinPoints(objective), 2);
                } else {
                    ConvergencePlotWidget.this.plot.setYLabel("");
                }
                ConvergencePlotWidget.this.plot.revalidate();
                ConvergencePlotWidget.this.plot.repaint();
            }
        });
    }

    private void paintList(List<Point2D.Double> list, int dataset) {
        int iteration = this.data.getIteration();
        for (int i = 0; i < list.size(); ++i) {
            Point2D.Double p1 = list.get(i);
            double x = p1.getX();
            double y = p1.getY();
            this.plot.addPoint(dataset, x, y, i != 0);
        }
        if (!list.isEmpty() && iteration > 0) {
            Point2D.Double p1 = list.get(list.size() - 1);
            double x = iteration;
            double y = p1.getY();
            this.plot.addPoint(dataset, x, y, true);
        }
    }

    @Override
    public void objectives(Collection<Objective> objectives) {
        for (Objective objective : objectives) {
            this.selection.addItem(objective);
            this.selection.setSelectedIndex(0);
            this.selection.repaint();
        }
    }

    class Selection
    extends ObjectiveDropDown
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public Selection() {
            this.addActionListener(this);
        }

        @Override
        public Objective getSelected() {
            return super.getSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvergencePlotWidget.this.doPaint();
        }
    }

    static class ObjectiveDropDown
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public ObjectiveDropDown() {
            this.setRenderer(new ListCellRenderer(){
                protected DefaultListCellRenderer renderer = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel cell = (JLabel)this.renderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    Objective objective = (Objective)value;
                    cell.setText(objective != null ? "objective: " + objective.getName() : "");
                    return cell;
                }
            });
            this.setMaximumSize(this.getPreferredSize());
        }

        public void addItem(Objective objective) {
            super.addItem(objective);
            this.setMaximumSize(this.getPreferredSize());
        }

        public Objective getSelected() {
            return (Objective)this.getSelectedItem();
        }

        public void setSelected(Objective objective) {
            this.setSelectedItem(objective);
        }
    }
}

