/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.config.visualization.DelayTask;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.viewer.IndividualMouseListener;
import org.opt4j.viewer.ObjectivesMonitor;
import org.opt4j.viewer.QTable;
import org.opt4j.viewer.SynchronizedIndividualSet;
import org.opt4j.viewer.ToolBarOrderComparator;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

@WidgetParameters(title="Archive Monitor", icon="icons/user-green.png")
public class ArchiveWidget
implements OptimizerIterationListener,
IndividualSetListener,
Widget,
ObjectivesMonitor.ObjectivesListener {
    protected static final int OFFSET = 2;
    protected final SynchronizedIndividualSet archive;
    protected List<Individual> swtIndividuals = Collections.emptyList();
    protected final List<Objective> objectives = new ArrayList<Objective>();
    protected final List<Objective> order = new ArrayList<Objective>();
    protected final JPanel panel = new JPanel();
    protected final JTable table;
    protected final JCheckBox autoUpdate;
    protected final JLabel sizeLabel;
    protected boolean changed = true;
    protected final List<IndividualMouseListener> individualMouseListeners = new CopyOnWriteArrayList<IndividualMouseListener>();
    protected final DelayTask task = new DelayTask(40L);
    protected static final String INDEX = "#";

    @Inject
    public ArchiveWidget(Archive archive) {
        this.archive = new SynchronizedIndividualSet((IndividualSet)archive);
        this.archive.addListener(this);
        this.table = this.getTable();
        JScrollPane scroll = new JScrollPane(this.table);
        this.autoUpdate = new JCheckBox();
        this.autoUpdate.setSelected(true);
        this.autoUpdate.setText("Auto Update");
        this.autoUpdate.setHorizontalTextPosition(10);
        this.autoUpdate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ArchiveWidget.this.autoUpdate.isSelected()) {
                    ArchiveWidget.this.paint();
                }
            }
        });
        this.sizeLabel = new JLabel(Integer.toString(archive.size()));
        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, 0));
        Dimension dim = new Dimension(10, 10);
        north.add(new Box.Filler(dim, dim, dim));
        north.add(new JLabel("Size: "));
        north.add(this.sizeLabel);
        north.add(Box.createHorizontalGlue());
        north.add(this.autoUpdate);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)north, "North");
        this.panel.add((Component)scroll, "Center");
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent arg0) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent arg0) {
                if (ArchiveWidget.this.updateOrder()) {
                    ArchiveWidget.this.paint();
                }
            }
        });
    }

    @Inject(optional=true)
    public void registerAtOptimizer(Optimizer optimizer) {
        optimizer.addOptimizerIterationListener((OptimizerIterationListener)this);
    }

    @Inject(optional=true)
    public void registerAtObjectivesMonitor(ObjectivesMonitor objectivesMonitor) {
        objectivesMonitor.addListener(this);
    }

    @Inject(optional=true)
    public void addMouseListeners(Set<IndividualMouseListener> mouseListeners) {
        this.individualMouseListeners.addAll(mouseListeners);
        this.sortIndividiualMouseListeners();
    }

    protected final JTable getTable() {
        Model model = new Model();
        QTable table = new QTable(model);
        table.addMouseListener(new TableMouseListener());
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(25);
        columnModel.getColumn(1).setPreferredWidth(140);
        return table;
    }

    protected void sortIndividiualMouseListeners() {
        ArrayList<IndividualMouseListener> list = new ArrayList<IndividualMouseListener>();
        list.addAll(this.individualMouseListeners);
        Collections.sort(list, new ToolBarOrderComparator());
        this.individualMouseListeners.clear();
        this.individualMouseListeners.addAll(list);
    }

    @Override
    public synchronized void init(Viewport viewport) {
    }

    protected boolean updateOrder() {
        if (this.table.getColumnCount() != this.objectives.size() + 2) {
            return false;
        }
        ArrayList<Objective> list = new ArrayList<Objective>();
        TableColumnModel model = this.table.getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int index = model.getColumn(i).getModelIndex();
            if (index < 2) continue;
            Objective o = this.objectives.get(index - 2);
            list.add(o);
        }
        if (!((Object)list).equals(this.order)) {
            this.order.clear();
            this.order.addAll(list);
            return true;
        }
        return false;
    }

    protected void paint() {
        this.task.execute(new Runnable(){

            @Override
            public void run() {
                final ArrayList<Individual> temp = new ArrayList<Individual>();
                temp.addAll(ArchiveWidget.this.archive);
                Collections.sort(temp, new Comp());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArchiveWidget.this.swtIndividuals = temp;
                        ArchiveWidget.this.sizeLabel.setText(Integer.toString(ArchiveWidget.this.swtIndividuals.size()));
                        if (ArchiveWidget.this.table != null) {
                            if (ArchiveWidget.this.table.getColumnCount() != ArchiveWidget.this.table.getModel().getColumnCount()) {
                                ArchiveWidget.this.table.createDefaultColumnsFromModel();
                            }
                            ArchiveWidget.this.table.revalidate();
                            ArchiveWidget.this.table.repaint();
                        }
                    }
                });
            }
        });
    }

    public void addIndividualMouseListener(IndividualMouseListener listener) {
        this.individualMouseListeners.add(listener);
        this.sortIndividiualMouseListeners();
    }

    public void removeIndivdiualMouseListener(IndividualMouseListener listener) {
        this.individualMouseListeners.remove(listener);
    }

    public synchronized void iterationComplete(int iteration) {
        if (this.changed && this.autoUpdate.isSelected()) {
            this.changed = false;
            this.paint();
        }
    }

    public synchronized void individualAdded(IndividualSet collection, Individual individual) {
        this.changed = true;
    }

    public synchronized void individualRemoved(IndividualSet collection, Individual individual) {
        this.changed = true;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void objectives(final Collection<Objective> obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArchiveWidget.this.order.addAll(obj);
                ArchiveWidget.this.objectives.addAll(obj);
            }
        });
        this.paint();
    }

    protected class Comp
    implements Comparator<Individual> {
        protected Comp() {
        }

        @Override
        public int compare(Individual arg0, Individual arg1) {
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            Objectives obj0 = arg0.getObjectives();
            Objectives obj1 = arg1.getObjectives();
            for (Objective o : ArchiveWidget.this.order) {
                assert (obj0.get(o) != null);
                assert (obj1.get(o) != null);
                Double v0 = obj0.get(o).getDouble();
                Double v1 = obj1.get(o).getDouble();
                int c = 0;
                if (v0 == null) {
                    if (v1 == null) continue;
                    c = 1;
                } else {
                    c = v1 == null ? -1 : v0.compareTo(v1);
                }
                if (c == 0) continue;
                if (o.getSign() == Objective.Sign.MIN) {
                    return c;
                }
                return -c;
            }
            return 0;
        }
    }

    protected class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected Model() {
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return ArchiveWidget.INDEX;
            }
            if (col == 1) {
                return "Individual";
            }
            int index = col - 2;
            Objective objective = ArchiveWidget.this.objectives.get(index);
            return objective.getName() + " (" + objective.getSign() + ")";
        }

        @Override
        public int getColumnCount() {
            return 2 + ArchiveWidget.this.objectives.size();
        }

        @Override
        public int getRowCount() {
            return ArchiveWidget.this.swtIndividuals.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                Individual individual = ArchiveWidget.this.swtIndividuals.get(row);
                if (individual != null) {
                    if (col == 0) {
                        return row + 1;
                    }
                    if (col == 1) {
                        return individual.getPhenotype();
                    }
                    if (individual.getState() == Individual.State.EVALUATED) {
                        int index = col - 2;
                        Objectives o = individual.getObjectives();
                        Objective objective = ArchiveWidget.this.objectives.get(index);
                        return o.get(objective).getValue();
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        private void reservTableShow(MouseEvent e, boolean released) {
            Point p;
            int row;
            if (ArchiveWidget.this.table.isEnabled() && (row = ArchiveWidget.this.table.rowAtPoint(p = new Point(e.getX(), e.getY()))) >= 0 && row < ArchiveWidget.this.table.getRowCount()) {
                Individual individual = ArchiveWidget.this.swtIndividuals.get(row);
                if (e.isPopupTrigger()) {
                    ArchiveWidget.this.table.getSelectionModel().setSelectionInterval(row, row);
                    JPopupMenu menu = new JPopupMenu();
                    for (IndividualMouseListener listener : ArchiveWidget.this.individualMouseListeners) {
                        listener.onPopup(individual, ArchiveWidget.this.table, p, menu);
                    }
                    if (menu.getComponentCount() > 0) {
                        menu.show(ArchiveWidget.this.table, p.x, p.y);
                    }
                } else if (e.getClickCount() == 2 && released) {
                    for (IndividualMouseListener listener : ArchiveWidget.this.individualMouseListeners) {
                        listener.onDoubleClick(individual, ArchiveWidget.this.table, p);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.reservTableShow(e, true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.reservTableShow(e, false);
        }
    }
}

