/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;

class SynchronizedIndividualList
implements List<Individual>,
IndividualSetListener {
    private final List<Individual> list = new ArrayList<Individual>();
    private final Object mutex;
    protected final Set<IndividualSetListener> listeners = new CopyOnWriteArraySet<IndividualSetListener>();

    public void addListener(IndividualSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IndividualSetListener listener) {
        this.listeners.remove(listener);
    }

    public SynchronizedIndividualList(IndividualSet collection) {
        this.mutex = this;
        collection.addListener((IndividualSetListener)this);
        while (true) {
            try {
                this.list.addAll((Collection<Individual>)collection);
            }
            catch (ConcurrentModificationException e) {
                this.list.clear();
                continue;
            }
            break;
        }
    }

    public void individualAdded(IndividualSet collection, Individual individual) {
        this.add(individual);
        for (IndividualSetListener listener : this.listeners) {
            listener.individualAdded(collection, individual);
        }
    }

    public void individualRemoved(IndividualSet collection, Individual individual) {
        this.remove(individual);
        for (IndividualSetListener listener : this.listeners) {
            listener.individualRemoved(collection, individual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Individual> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Individual e) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Individual> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends Individual> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual get(int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual set(int index, Individual element) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Individual element) {
        Object object = this.mutex;
        synchronized (object) {
            this.list.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual remove(int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<Individual> listIterator() {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<Individual> listIterator(int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.listIterator(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Individual> subList(int fromIndex, int toIndex) {
        Object object = this.mutex;
        synchronized (object) {
            return this.list.subList(fromIndex, toIndex);
        }
    }
}

