/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import ptolemy.plot.Plot;

public abstract class PlotLive
extends Plot
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Thread _plotLiveThread = null;
    private boolean _plotting = false;
    private boolean _paused = false;
    private JButton _startButton;
    private JButton _stopButton;

    public abstract void addPoints();

    public void pause() {
        this._paused = true;
        this._plotting = false;
        this._stopButton.setEnabled(false);
        this._startButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._plotting || this._paused) {
            if (this._plotting) {
                this.addPoints();
                Thread.yield();
                continue;
            }
            if (!this._paused) continue;
            PlotLive plotLive = this;
            synchronized (plotLive) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setButtons(boolean visible) {
        super.setButtons(visible);
        if (this._startButton == null) {
            this._startButton = new JButton("start");
            this._startButton.addActionListener(new StartButtonListener());
            this.add(this._startButton);
        }
        this._startButton.setVisible(visible);
        if (this._stopButton == null) {
            this._stopButton = new JButton("stop");
            this._stopButton.addActionListener(new StopButtonListener());
            this.add(this._stopButton);
        }
        this._stopButton.setVisible(visible);
        if (visible) {
            this._stopButton.setEnabled(false);
            this._startButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this._plotting = true;
        this._paused = false;
        this._stopButton.setEnabled(true);
        this._startButton.setEnabled(false);
        if (this._plotLiveThread == null) {
            this._plotLiveThread = new Thread((Runnable)this, "PlotLive Thread");
            this._plotLiveThread.start();
        } else {
            PlotLive plotLive = this;
            synchronized (plotLive) {
                this.notifyAll();
            }
        }
    }

    public void stop() {
        this._plotting = false;
        this._paused = false;
        this._plotLiveThread = null;
    }

    class StopButtonListener
    implements ActionListener {
        StopButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PlotLive.this.pause();
        }
    }

    class StartButtonListener
    implements ActionListener {
        StartButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PlotLive.this.start();
        }
    }
}

