/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import ptolemy.plot.PlotBox;
import ptolemy.plot.zoomBox.ZoomIcons;

public class AutoZoomButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private PlotBox plotBox = null;

    public AutoZoomButton() {
        super(ZoomIcons.getIcon("icons/view-zoom-auto.png"));
        this.addActionListener(this);
        this.setEnabled(false);
        this.setToolTipText("Auto Zoom");
        this.setPreferredSize(this.getMinimumSize());
    }

    public PlotBox getPlotBox() {
        return this.plotBox;
    }

    public void setPlotBox(PlotBox plotBox) {
        if (this.plotBox != null) {
            this.plotBox.removeListener(this);
        }
        this.plotBox = plotBox;
        plotBox.registerListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.plotBox != null) {
            if (e.getSource() == this) {
                this.plotBox.reactivateAutoScale();
            } else if (e.getSource() == this.plotBox && e.getActionCommand() == PlotBox.Action.MANUAL_ZOOM_ACTIVATED.toString()) {
                this.setEnabled(true);
            } else if (e.getSource() == this.plotBox && e.getActionCommand() == PlotBox.Action.AUTOMATIC_ZOOM_ACTIVATED.toString()) {
                this.setEnabled(false);
            }
        }
    }
}

