/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.start;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.binder.ConstantBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.Message;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.config.Property;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.optimizer.ControlListener;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.OptimizerStateListener;
import org.opt4j.core.start.Constant;

public abstract class Opt4JModule
extends AbstractModule {
    public static Scope SINGLETON = Scopes.SINGLETON;

    protected ConstantBindingBuilder bindConstant(Class<? extends Annotation> annotation) {
        return this.bindConstant().annotatedWith(annotation);
    }

    protected ConstantBindingBuilder bindConstant(Annotation annotation) {
        return this.bindConstant().annotatedWith(annotation);
    }

    protected void configure() {
        PropertyModule module = new PropertyModule((Module)this);
        for (Property property : module.getProperties()) {
            for (Annotation annotation : property.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null) continue;
                Class<?> type = property.getType();
                Object value = property.getValue();
                ConstantBindingBuilder builder = this.bindConstant(annotation);
                if (type.equals(Integer.TYPE)) {
                    builder.to(((Integer)value).intValue());
                    continue;
                }
                if (type.equals(Long.TYPE)) {
                    builder.to(((Long)value).longValue());
                    continue;
                }
                if (type.equals(Double.TYPE)) {
                    builder.to(((Double)value).doubleValue());
                    continue;
                }
                if (type.equals(Float.TYPE)) {
                    builder.to(((Float)value).floatValue());
                    continue;
                }
                if (type.equals(Byte.TYPE)) {
                    builder.to(((Byte)value).byteValue());
                    continue;
                }
                if (type.equals(Short.TYPE)) {
                    builder.to(((Short)value).shortValue());
                    continue;
                }
                if (type.equals(Boolean.TYPE)) {
                    builder.to(((Boolean)value).booleanValue());
                    continue;
                }
                if (type.equals(Character.TYPE)) {
                    builder.to(((Character)value).charValue());
                    continue;
                }
                if (type.equals(String.class)) {
                    builder.to((String)value);
                    continue;
                }
                if (type.equals(Class.class)) {
                    builder.to((Class)value);
                    continue;
                }
                if (value instanceof Enum) {
                    builder.to((Enum)value);
                    continue;
                }
                String message = "Constant type not bindable: " + type + " of field " + property.getName() + " in module " + ((Object)((Object)this)).getClass().getName();
                throw new ConfigurationException(Arrays.asList(new Message(message)));
            }
        }
        this.multi(OptimizerStateListener.class);
        this.multi(OptimizerIterationListener.class);
        this.multi(IndividualStateListener.class);
        this.config();
    }

    protected void multi(Class<?> clazz) {
        Multibinder.newSetBinder((Binder)this.binder(), clazz);
    }

    protected abstract void config();

    public static ConstantImpl constant(String value, Class<?> namespace) {
        return new ConstantImpl(value, namespace);
    }

    protected ConstantBindingBuilder bindConstant(String value) {
        return this.bindConstant(value, Object.class);
    }

    protected ConstantBindingBuilder bindConstant(String value, Class<?> namespace) {
        assert (namespace != null);
        ConstantImpl c = new ConstantImpl(value, namespace);
        return this.bindConstant(c);
    }

    public void addOptimizerStateListener(Class<? extends OptimizerStateListener> listener) {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), OptimizerStateListener.class);
        multibinder.addBinding().to(listener);
    }

    public void addOptimizerIterationListener(Class<? extends OptimizerIterationListener> listener) {
        assert (this.binder() != null);
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), OptimizerIterationListener.class);
        multibinder.addBinding().to(listener);
    }

    public void addIndividualStateListener(Class<? extends IndividualStateListener> listener) {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), IndividualStateListener.class);
        multibinder.addBinding().to(listener);
    }

    public void addControlListener(Class<? extends ControlListener> listener) {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), ControlListener.class);
        multibinder.addBinding().to(listener);
    }

    static class ConstantImpl
    implements Serializable,
    Constant {
        private final String value;
        private final Class<?> namespace;
        private static final long serialVersionUID = 0L;

        ConstantImpl(String value, Class<?> namespace) {
            this.value = value;
            this.namespace = namespace;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<?> namespace() {
            return this.namespace;
        }

        @Override
        public int hashCode() {
            return (127 * "value".hashCode() ^ this.value.hashCode()) + (127 * "namespace".hashCode() ^ this.namespace.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof Constant)) {
                return false;
            }
            Constant other = (Constant)o;
            return this.value.equals(other.value()) && this.namespace.equals(other.namespace());
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Constant.class;
        }

        @Override
        public String toString() {
            return "@" + Constant.class.getName() + "(value=" + this.value + ", namespace=" + this.namespace.getName() + ")";
        }
    }
}

