/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.problem;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.util.HashSet;
import org.opt4j.core.Genotype;
import org.opt4j.core.config.annotations.Category;
import org.opt4j.core.config.annotations.Icon;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.start.Opt4JModule;

@Icon(value="icons/gear-gray.png")
@Category
public abstract class ProblemModule
extends Opt4JModule {
    protected void bindProblem(Class<? extends Creator<? extends Genotype>> creator, Class<? extends Decoder<? extends Genotype, ? extends Object>> decoder, Class<? extends Evaluator<? extends Object>> evaluator) {
        ProblemModule.bindProblem(this.binder(), creator, decoder, evaluator);
    }

    protected void addEvaluator(Class<? extends Evaluator<? extends Object>> evaluator) {
        ProblemModule.addEvaluator(this.binder(), evaluator);
    }

    public static void addEvaluator(Binder binder, Class<? extends Evaluator<? extends Object>> evaluator) {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Evaluator<Object>>(){});
        multibinder.addBinding().to(evaluator);
    }

    public static void bindProblem(Binder binder, Class<? extends Creator<? extends Genotype>> creator, Class<? extends Decoder<? extends Genotype, ? extends Object>> decoder, Class<? extends Evaluator<? extends Object>> evaluator) {
        HashSet<Class<Object>> classes = new HashSet<Class<Object>>();
        if (creator != null) {
            classes.add(creator);
        }
        if (decoder != null) {
            classes.add(decoder);
        }
        for (Class clazz : classes) {
            binder.bind(clazz).in(SINGLETON);
        }
        if (creator != null) {
            binder.bind((TypeLiteral)new TypeLiteral<Creator<Genotype>>(){}).to(creator);
        }
        if (decoder != null) {
            binder.bind((TypeLiteral)new TypeLiteral<Decoder<Genotype, Object>>(){}).to(decoder);
        }
        if (evaluator != null) {
            ProblemModule.addEvaluator(binder, evaluator);
        }
    }
}

