/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opt4j.core.config.PropertyModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModuleSaver {
    public boolean save(String filename, Collection<? extends Module> modules) {
        File file = new File(filename);
        return this.save(file, modules);
    }

    public boolean save(File file, Collection<? extends Module> modules) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            return this.write((OutputStream)new FileOutputStream(file), modules);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(OutputStream out, Collection<? extends Module> modules) {
        try {
            Document document = this.getEmptyDocument();
            Element configuration = document.createElement("configuration");
            document.appendChild(configuration);
            for (Module module : modules) {
                configuration.appendChild(this.getNode(module, document));
            }
            StreamResult result = new StreamResult(new OutputStreamWriter(out, "utf-8"));
            DOMSource dOMSource = new DOMSource(document);
            this.getStandardTransformer().transform(dOMSource, result);
            return true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean write(OutputStream out, Module module) {
        try {
            Document document = this.getEmptyDocument();
            document.appendChild(this.getNode(module, document));
            StreamResult result = new StreamResult(new OutputStreamWriter(out, "utf-8"));
            DOMSource source = new DOMSource(document);
            this.getStandardTransformer().transform(source, result);
            return true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String toXMLString(Module module) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write((OutputStream)out, module);
        return out.toString();
    }

    public String toXMLString(Collection<? extends Module> modules) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write((OutputStream)out, modules);
        return out.toString();
    }

    protected Document getEmptyDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        return document;
    }

    protected Transformer getStandardTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("indent-number", 2);
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        return transformer;
    }

    protected Node getNode(Module module, Document document) {
        PropertyModule pModule = module instanceof PropertyModule ? (PropertyModule)module : new PropertyModule(module);
        Node node = pModule.getConfiguration(document);
        return node;
    }
}

