/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class Icons {
    public static final String XMLTAG = "icons/xmltag.png";
    public static final String XML = "icons/xml.png";
    public static final String OPTIMIZER = "icons/tools-blue.png";
    public static final String PROBLEM = "icons/gear-gray.png";
    public static final String ARCHIVE = "icons/user-green.png";
    public static final String POPULATION = "icons/user-blue.png";
    public static final String PARETO = "icons/stat.png";
    public static final String CONVERGENCE = "icons/convergence.png";
    public static final String PLAY = "icons/play.png";
    public static final String OPERATOR = "icons/tools-orange.png";
    public static final String APPLICATION = "icons/appl.png";
    public static final String PUZZLE_GREEN = "icons/puzzle-green.png";
    public static final String PUZZLE_BLUE = "icons/puzzle-blue.png";
    public static final String SELECTOR = "icons/tools-orange.png";
    public static final String HELP = "icons/help.png";
    public static final String CONTROL_START = "icons/control_start.png";
    public static final String CONTROL_STOP = "icons/control_stop.png";
    public static final String CONTROL_PAUSE = "icons/control_pause.png";
    public static final String CONTROL_TERM = "icons/control_term.png";
    public static final String FOLDER = "icons/folder.png";
    public static final String FOLDER_ADD = "icons/folder_add.png";
    public static final String SFOLDER = "icons/small_folder.png";
    public static final String DISK = "icons/disk.png";
    public static final String CONSOLE = "icons/console.png";
    public static final String OPT4J = "icons/logo2.png";
    public static final String ADD = "icons/add.png";
    public static final String DELETE = "icons/delete.png";
    public static final String LOADING = "icons/loading.gif";
    public static final String TEXT = "icons/text.png";

    public static URL getURL(String filename) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL url = classLoader.getResource(filename);
        return url;
    }

    public static ImageIcon getIcon(String filename) {
        URL url = Icons.getURL(filename);
        try {
            return new ImageIcon(url);
        }
        catch (NullPointerException e) {
            System.err.println("Image " + filename + " not found.");
            e.printStackTrace();
            return null;
        }
    }

    public static ImageIcon getDefault() {
        BufferedImage image = new BufferedImage(16, 16, 2);
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }

    public static ImageIcon merge(ImageIcon ... icons) {
        class MergedIcon
        extends ImageIcon {
            private final ImageIcon[] icons;

            public MergedIcon(ImageIcon[] icons) {
                this.icons = icons;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                for (ImageIcon icon : this.icons) {
                    icon.paintIcon(c, g, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return this.icons[0].getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.icons[0].getIconHeight();
            }
        }
        return new MergedIcon(icons);
    }
}

