/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSetListener;

public class IndividualSet
implements Set<Individual> {
    protected final Set<Individual> individuals = new LinkedHashSet<Individual>();
    protected final Set<IndividualSetListener> listeners = new CopyOnWriteArraySet<IndividualSetListener>();

    @Override
    public boolean add(Individual individual) {
        boolean b = false;
        if (!this.individuals.contains(individual)) {
            b = this.individuals.add(individual);
        }
        if (b) {
            for (IndividualSetListener listener : this.listeners) {
                listener.individualAdded(this, individual);
            }
        }
        return b;
    }

    @Override
    public Iterator<Individual> iterator() {
        final Iterator<Individual> iterator = this.individuals.iterator();
        return new Iterator<Individual>(){
            Individual current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Individual next() {
                this.current = (Individual)iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                iterator.remove();
                if (this.current != null) {
                    for (IndividualSetListener listener : IndividualSet.this.listeners) {
                        listener.individualRemoved(IndividualSet.this, this.current);
                    }
                }
            }
        };
    }

    @Override
    public int size() {
        return this.individuals.size();
    }

    public void addListener(IndividualSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IndividualSetListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        Iterator<Individual> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean addAll(Collection<? extends Individual> c) {
        boolean res = false;
        for (Individual individual : c) {
            boolean b = this.individuals.add(individual);
            if (b) {
                for (IndividualSetListener listener : this.listeners) {
                    listener.individualAdded(this, individual);
                }
            }
            res |= b;
        }
        return res;
    }

    public boolean addAll(Individual ... c) {
        boolean res = false;
        for (Individual individual : c) {
            boolean b = this.individuals.add(individual);
            if (b) {
                for (IndividualSetListener listener : this.listeners) {
                    listener.individualAdded(this, individual);
                }
            }
            res |= b;
        }
        return res;
    }

    @Override
    public boolean contains(Object o) {
        return this.individuals.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.individuals.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.individuals.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        boolean value = this.individuals.remove(o);
        if (value) {
            for (IndividualSetListener listener : this.listeners) {
                listener.individualRemoved(this, (Individual)o);
            }
        }
        return value;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean res = false;
        Iterator<Individual> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            res = true;
        }
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean res = false;
        Iterator<Individual> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            res = true;
        }
        return res;
    }

    @Override
    public Object[] toArray() {
        return this.individuals.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.individuals.toArray(a);
    }
}

