/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.start;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.opt4j.core.config.ExecutionEnvironment;
import org.opt4j.core.config.Icons;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.Task;
import org.opt4j.core.config.visualization.DefaultTasksPanel;
import org.opt4j.core.config.visualization.Format;
import org.opt4j.core.config.visualization.SelectedModules;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.start.Opt4JTask;
import org.opt4j.core.start.Progress;

public class Opt4JTasksPanel
extends DefaultTasksPanel {
    protected final Map<Task, Progress> progessMap = new WeakHashMap<Task, Progress>();
    protected final SelectedModules selectedModules;

    @Inject
    public Opt4JTasksPanel(ExecutionEnvironment executionEnvironment, Format format, SelectedModules selectedModules) {
        super(executionEnvironment, format);
        this.selectedModules = selectedModules;
    }

    @Override
    public void startup() {
        super.startup();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.table.addMouseListener(new PopupListener());
    }

    @Override
    protected AbstractTableModel getModel() {
        return new Model();
    }

    @Override
    protected JTable getTable() {
        return new Table();
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.display(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.display(e);
            }
        }

        void display(MouseEvent event) {
            if (event.isPopupTrigger()) {
                try {
                    Point p = event.getPoint();
                    int row = Opt4JTasksPanel.this.table.rowAtPoint(p);
                    Opt4JTask task = (Opt4JTask)Opt4JTasksPanel.this.executionEnvironment.getTasks().get(row);
                    JPopupMenu menu = new JPopupMenu();
                    this.addConfigLoadMenuItems(menu, task);
                    if (task.getState() == Task.State.EXECUTING) {
                        menu.addSeparator();
                        this.addControlMenuItems(menu, task);
                    }
                    menu.show(event.getComponent(), event.getX(), event.getY());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }

        private void addConfigLoadMenuItems(JPopupMenu menu, final Opt4JTask task) {
            JMenuItem loadConfig = new JMenuItem("Restore Configuration", Icons.getIcon("icons/folder_add.png"));
            loadConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Opt4JTasksPanel.this.selectedModules.clear();
                    for (Module module : task.getModules()) {
                        PropertyModule pModule = module instanceof PropertyModule ? (PropertyModule)module : new PropertyModule(module);
                        Opt4JTasksPanel.this.selectedModules.add(pModule);
                    }
                }
            });
            menu.add(loadConfig);
        }

        private void addControlMenuItems(JPopupMenu menu, Opt4JTask task) {
            Control control;
            try {
                control = task.getInstance(Control.class);
            }
            catch (RuntimeException e) {
                return;
            }
            assert (control != null) : "Task should be in state EXECUTING but is in state " + (Object)((Object)task.getState());
            JMenuItem start = new JMenuItem("Start", Icons.getIcon("icons/control_start.png"));
            JMenuItem pause = new JMenuItem("Pause", Icons.getIcon("icons/control_pause.png"));
            JMenuItem stop = new JMenuItem("STOP", Icons.getIcon("icons/control_stop.png"));
            JMenuItem terminate = new JMenuItem("Terminate", Icons.getIcon("icons/control_term.png"));
            terminate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    control.doTerminate();
                }
            });
            start.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    control.doStart();
                }
            });
            pause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    control.doPause();
                }
            });
            stop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    control.doStop();
                }
            });
            if (control != null) {
                switch (control.getState()) {
                    case RUNNING: {
                        start.setEnabled(false);
                        break;
                    }
                    case PAUSED: {
                        pause.setEnabled(false);
                        break;
                    }
                    case TERMINATED: {
                        terminate.setEnabled(false);
                        start.setEnabled(false);
                        pause.setEnabled(false);
                        stop.setEnabled(false);
                        break;
                    }
                    case STOPPED: {
                        start.setEnabled(false);
                        pause.setEnabled(false);
                        stop.setEnabled(false);
                    }
                }
            } else {
                terminate.setEnabled(false);
                start.setEnabled(false);
                pause.setEnabled(false);
                stop.setEnabled(false);
            }
            menu.add(start);
            menu.add(pause);
            menu.add(stop);
            menu.add(terminate);
        }
    }

    protected class Model
    extends AbstractTableModel {
        protected final String[] columnNames = new String[]{"Task", "State", "Progress"};

        protected Model() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Opt4JTasksPanel.this.executionEnvironment.getTasks().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Opt4JTask task = (Opt4JTask)Opt4JTasksPanel.this.executionEnvironment.getTasks().get(row);
            if (column == 0) {
                return row + " " + task.toString();
            }
            if (column == 1) {
                if (task.getException() != null) {
                    return "EXCEPTION: \n" + task.getException();
                }
                try {
                    Control control = task.getInstance(Control.class);
                    return "" + (Object)((Object)control.getState());
                }
                catch (RuntimeException e) {
                    return "";
                }
            }
            if (column == 2) {
                switch (task.getState()) {
                    case EXECUTING: {
                        Progress progress = Opt4JTasksPanel.this.progessMap.get(task);
                        if (progress != null) {
                            return progress;
                        }
                        Optimizer optimizer = task.getInstance(Optimizer.class);
                        if (optimizer != null) {
                            progress = task.getInstance(Progress.class);
                            optimizer.addOptimizerIterationListener(progress);
                            Opt4JTasksPanel.this.progessMap.put(task, progress);
                            return progress;
                        }
                        return " " + (Object)((Object)task.getState());
                    }
                }
                return "  " + (Object)((Object)task.getState());
            }
            return null;
        }

        @Override
        public String getColumnName(int i) {
            return this.columnNames[i];
        }
    }

    class Table
    extends JTable {
        Table() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (!(renderer instanceof ProgressRenderer)) {
                Task task = Opt4JTasksPanel.this.executionEnvironment.getTasks().get(row);
                if (task.getException() == null) {
                    c.setForeground(Color.BLACK);
                } else {
                    c.setForeground(Color.RED);
                }
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                    Object value = this.getValueAt(row, column);
                    if (value != null) {
                        char[] chars = value.toString().toCharArray();
                        int length = jc.getFontMetrics(jc.getFont()).charsWidth(chars, 0, chars.length);
                        if (this.getColumnModel().getColumn(column).getWidth() < length) {
                            jc.setToolTipText(Opt4JTasksPanel.this.format.formatTooltip(value.toString()));
                        } else {
                            jc.setToolTipText(null);
                        }
                    }
                }
            }
            return c;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 2) {
                return new ProgressRenderer();
            }
            return super.getCellRenderer(row, column);
        }
    }

    static class ProgressRenderer
    extends DefaultTableCellRenderer {
        private final JProgressBar b = new JProgressBar(0, 100);

        public ProgressRenderer() {
            this.setOpaque(true);
            this.b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.b.setStringPainted(true);
            this.b.setBackground(Color.WHITE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Progress) {
                Progress progress = (Progress)value;
                Double v = progress.get();
                if (v == null) {
                    v = 0.0;
                }
                this.b.setValue((int)(v * 100.0));
                this.b.setString("" + progress.getCurrentIteration() + "/" + progress.getMaxIterations());
                return this.b;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

