/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.start;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Set;
import org.opt4j.core.Genotype;
import org.opt4j.core.config.Task;
import org.opt4j.core.config.TaskStateListener;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.ControlListener;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.problem.Creator;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.start.Parameters;

public class Opt4JTask
extends Task
implements ControlListener,
OptimizerIterationListener {
    protected Optimizer optimizer = null;
    protected Injector injector = null;
    protected Injector parentInjector = null;
    protected final boolean closeOnStop;
    protected boolean isClosed = false;

    @Inject
    public Opt4JTask() {
        this(true);
    }

    public Opt4JTask(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
    }

    @Override
    public void execute() throws Exception {
        this.open();
        this.check(this.injector);
        Control control = (Control)this.injector.getInstance(Control.class);
        this.optimizer = (Optimizer)this.injector.getInstance(Optimizer.class);
        this.stateChanged();
        control.addListener(this);
        this.optimizer.addOptimizerIterationListener(this);
        Optimizer optimizer = (Optimizer)this.injector.getInstance(Optimizer.class);
        optimizer.startOptimization();
        if (this.closeOnStop) {
            this.close();
        }
    }

    public void init(Injector injector) {
        this.parentInjector = injector;
    }

    public synchronized void close() {
        this.optimizer = null;
        this.injector = null;
        this.isClosed = true;
    }

    public synchronized void open() {
        if (this.injector == null && !this.isClosed) {
            if (!this.isInit) {
                throw new RuntimeException("Task is not initialized. Call method init(modules) first.");
            }
            this.injector = this.parentInjector == null ? Guice.createInjector((Iterable)this.modules) : this.parentInjector.createChildInjector((Iterable)this.modules);
        }
    }

    public int getIteration() {
        Optimizer optimizer = this.getOptimizer();
        if (optimizer == null) {
            return 0;
        }
        return optimizer.getIteration();
    }

    public <O> O getInstance(Class<O> type) {
        Injector injector = this.getInjector();
        if (injector == null) {
            return null;
        }
        return (O)injector.getInstance(type);
    }

    protected Injector getInjector() {
        return this.injector;
    }

    protected Optimizer getOptimizer() {
        return this.optimizer;
    }

    private void check(Injector injector) {
        Creator creator = null;
        Decoder decoder = null;
        Set evaluators = null;
        try {
            creator = (Creator)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Creator<Genotype>>(){}));
            decoder = (Decoder)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Decoder<Genotype, Object>>(){}));
            evaluators = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Evaluator<Object>>>(){}));
        }
        catch (Exception e) {
            throw new RuntimeException("Problem configuration Exception: \n" + e.getLocalizedMessage(), e);
        }
        try {
            injector.getInstance(Optimizer.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Optimizer configuration Exception: \n" + e.getLocalizedMessage(), e);
        }
        try {
            Type creatorType0 = Parameters.getType(Creator.class, creator, "G");
            Type decoderType0 = Parameters.getType(Decoder.class, decoder, "G");
            Type decoderType1 = Parameters.getType(Decoder.class, decoder, "P");
            Type evaluatorType0 = Parameters.getType(Evaluator.class, evaluators, "P");
            Class<Object> creatorGenotype = Parameters.getClass(creatorType0);
            Class<Object> decoderGenotype = Parameters.getClass(decoderType0);
            Class<Object> decoderPhenotype = Parameters.getClass(decoderType1);
            Class<Object> evaluatorPhenotype = Parameters.getClass(evaluatorType0);
            if (creatorGenotype == null) {
                creatorGenotype = Genotype.class;
            }
            if (decoderGenotype == null) {
                decoderGenotype = Genotype.class;
            }
            if (decoderPhenotype == null) {
                decoderPhenotype = Object.class;
            }
            if (evaluatorPhenotype == null) {
                evaluatorPhenotype = Object.class;
            }
            boolean a = decoderGenotype.isAssignableFrom(creatorGenotype);
            boolean b = evaluatorPhenotype.isAssignableFrom(decoderPhenotype);
            if (!a) {
                throw new IllegalArgumentException("Creator(" + creator.getClass() + ") and Decoder(" + decoder.getClass() + ") are not compatible. Creator creates \"" + creatorGenotype + "\", Decoder decodes \"" + decoderGenotype + "\".");
            }
            if (!b) {
                throw new IllegalArgumentException("Decoder(" + decoder.getClass() + ") and Evaluator(" + evaluators + ") are not compatible. Decoder decodes \"" + decoderPhenotype + "\", Evaluator evaluates \"" + evaluatorPhenotype + "\".");
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Override
    public void stateChanged(Control.State state) {
        this.stateChanged();
    }

    @Override
    public void iterationComplete(int iteration) {
        this.stateChanged();
    }

    private void stateChanged() {
        for (TaskStateListener listener : this.listeners) {
            listener.stateChanged(this);
        }
    }
}

