/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.problem;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.opt4j.core.Objectives;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.core.problem.Priority;

public class MultiEvaluator
implements Evaluator<Object> {
    protected final Set<Evaluator<Object>> evaluators = new TreeSet<Evaluator<Object>>(new PriorityComparator());
    protected final Provider<Objectives> objectivesProvider;

    @Inject
    public MultiEvaluator(Set<Evaluator<Object>> evaluators, Provider<Objectives> objectivesProvider) {
        this.evaluators.addAll(evaluators);
        this.objectivesProvider = objectivesProvider;
    }

    @Override
    public Objectives evaluate(Object phenotype) {
        Objectives objectives = (Objectives)this.objectivesProvider.get();
        for (Evaluator<Object> evaluator : this.evaluators) {
            Objectives obj = evaluator.evaluate(phenotype);
            objectives.addAll(obj);
        }
        return objectives;
    }

    private static class PriorityComparator
    implements Comparator<Evaluator<Object>> {
        private PriorityComparator() {
        }

        @Override
        public int compare(Evaluator<Object> o1, Evaluator<Object> o2) {
            int p2;
            int p1 = this.getPriority(o1);
            if (p1 == (p2 = this.getPriority(o2))) {
                return o1.hashCode() - o2.hashCode();
            }
            return p1 - p2;
        }

        protected int getPriority(Evaluator<Object> evaluator) {
            if (evaluator.getClass().isAnnotationPresent(Priority.class)) {
                Priority priority = evaluator.getClass().getAnnotation(Priority.class);
                return priority.value();
            }
            return 0;
        }
    }
}

