/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.genotype;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.Bounds;
import org.opt4j.core.genotype.FixedBounds;
import org.opt4j.core.genotype.ListGenotype;

public class IntegerGenotype
extends ArrayList<Integer>
implements ListGenotype<Integer> {
    protected final Bounds<Integer> bounds;
    private static final long serialVersionUID = 1L;

    public IntegerGenotype(int lowerBound, int upperBound) {
        this(new FixedBounds<Integer>(lowerBound, upperBound));
    }

    public IntegerGenotype(Bounds<Integer> bounds) {
        this.bounds = bounds;
    }

    public int getLowerBound(int index) {
        return this.bounds.getLowerBound(index);
    }

    public int getUpperBound(int index) {
        return this.bounds.getUpperBound(index);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(Bounds.class);
            return (G)((Genotype)cstr.newInstance(this.bounds));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(Random random, int n) {
        for (int i = 0; i < n; ++i) {
            int lo = this.getLowerBound(i);
            int hi = this.getUpperBound(i);
            int value = lo + random.nextInt(hi - lo + 1);
            if (i >= this.size()) {
                this.add(value);
                continue;
            }
            this.set(i, value);
        }
    }
}

