/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.genotype;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.Bounds;
import org.opt4j.core.genotype.FixedBounds;
import org.opt4j.core.genotype.ListGenotype;

public class DoubleGenotype
extends ArrayList<Double>
implements ListGenotype<Double> {
    protected final Bounds<Double> bounds;

    public DoubleGenotype() {
        this(0.0, 1.0);
    }

    public DoubleGenotype(double lowerBound, double upperBound) {
        this(new FixedBounds<Double>(lowerBound, upperBound));
    }

    public DoubleGenotype(Bounds<Double> bounds) {
        this.bounds = bounds;
    }

    public double getLowerBound(int index) {
        return this.bounds.getLowerBound(index);
    }

    public double getUpperBound(int index) {
        return this.bounds.getUpperBound(index);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(Bounds.class);
            return (G)((Genotype)cstr.newInstance(this.bounds));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(Random random, int n) {
        for (int i = 0; i < n; ++i) {
            double lo = this.getLowerBound(i);
            double hi = this.getUpperBound(i);
            double value = lo + random.nextDouble() * (hi - lo);
            if (i >= this.size()) {
                this.add(value);
                continue;
            }
            this.set(i, value);
        }
    }
}

