/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.opt4j.core.config.Icons;
import org.opt4j.core.config.Property;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.Requirement;
import org.opt4j.core.config.visualization.DialogLayout;
import org.opt4j.core.config.visualization.FileChooser;
import org.opt4j.core.config.visualization.Format;

public class PropertyPanel
extends JPanel {
    protected final PropertyModule module;
    protected final FileChooser fileChooser;
    protected final Format format;
    protected final JPanel panel;
    protected final Map<Property, Component> components = new HashMap<Property, Component>();

    public PropertyPanel(PropertyModule module, FileChooser fileChooser, Format format) {
        this.module = module;
        this.fileChooser = fileChooser;
        this.format = format;
        this.fillComponentsMap();
        this.panel = new JPanel(new DialogLayout(20, 2));
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updatePropertyPanel();
        this.update();
        this.setLayout(new BorderLayout());
        this.add("North", this.panel);
    }

    protected Component createComponent(final Property property) {
        JComponent component = null;
        Object value = property.getValue();
        Class<?> type = property.getType();
        if (type.isEnum()) {
            Object[] obj = new Object[type.getEnumConstants().length];
            for (int k = 0; k < obj.length; ++k) {
                obj[k] = type.getEnumConstants()[k];
            }
            final JComboBox<Object> box = new JComboBox<Object>(obj);
            box.setSelectedItem(value);
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object selected = box.getSelectedItem();
                    try {
                        property.setValue(selected);
                        PropertyPanel.this.update();
                    }
                    catch (InvocationTargetException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            });
            component = box;
        } else if (type.equals(Boolean.TYPE)) {
            final JCheckBox checkbox = new JCheckBox();
            boolean b = (Boolean)property.getValue();
            checkbox.setSelected(b);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = checkbox.isSelected();
                    try {
                        property.setValue(b);
                        PropertyPanel.this.update();
                    }
                    catch (InvocationTargetException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            });
            component = checkbox;
        } else {
            final JTextField field = new JTextField();
            if (property.isNumber()) {
                field.setHorizontalAlignment(4);
            }
            if (value == null) {
                field.setText("");
            } else {
                field.setText(value.toString());
            }
            field.addFocusListener(new FocusAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusLost(FocusEvent e) {
                    String value = PropertyPanel.this.format(property, field.getText());
                    try {
                        property.setValue(value);
                    }
                    catch (InvocationTargetException ex) {
                        System.err.println(ex.getMessage());
                    }
                    finally {
                        field.setText(property.getValue().toString());
                        PropertyPanel.this.update();
                    }
                }
            });
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    String value = PropertyPanel.this.format(property, field.getText());
                    try {
                        property.setValue(value);
                    }
                    catch (InvocationTargetException ex) {
                        System.err.println(ex.getMessage());
                        field.setText(property.getValue().toString());
                    }
                }
            });
            component = field;
        }
        return component;
    }

    protected String format(Property property, String value) {
        if (property.isNumber()) {
            if ((value = value.trim()).equals("")) {
                value = "0";
            } else if (value.equals("-")) {
                value = "0";
            } else {
                if (value.startsWith(".")) {
                    value = "0" + value;
                }
                if (value.endsWith(".")) {
                    value = value + "0";
                }
            }
            return value;
        }
        return value;
    }

    protected void fillComponentsMap() {
        for (Property property : this.module.getProperties()) {
            Component component = this.createComponent(property);
            this.components.put(property, component);
        }
    }

    protected void updatePropertyPanel() {
        this.panel.removeAll();
        for (final Property property : this.module.getProperties()) {
            if (!property.isActive()) continue;
            String name = property.getName();
            int i = this.getIndent(property);
            String s = "";
            for (int j = 0; j < i; ++j) {
                s = s + "     ";
            }
            if (i > 0) {
                s = s.substring(2) + "\u21aa ";
            }
            JPanel labelPanel = new JPanel(new FlowLayout(0, 0, 0));
            JLabel label = new JLabel(s + name);
            label.setFocusable(false);
            String tooltip = this.format.getTooltip(property);
            if (tooltip != null) {
                label.setToolTipText(tooltip);
            }
            labelPanel.add(label);
            org.opt4j.core.config.annotations.File file = property.getAnnotation(org.opt4j.core.config.annotations.File.class);
            if (file != null) {
                JButton browse = new JButton(Icons.getIcon("icons/folder.png"));
                browse.setFocusable(false);
                browse.setBorderPainted(false);
                browse.setContentAreaFilled(false);
                browse.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                browse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertyPanel.this.selectFile(property);
                    }
                });
                browse.setCursor(new Cursor(12));
                browse.setToolTipText("Browse ...");
                labelPanel.add(browse);
            }
            this.panel.add(labelPanel);
            Component component = this.components.get(property);
            this.panel.add(component);
        }
    }

    protected void update() {
        this.updatePropertyPanel();
        this.revalidate();
        this.repaint();
    }

    public PropertyModule getModule() {
        return this.module;
    }

    protected int getIndent(Property property) {
        int i = 0;
        for (Requirement requirement : property.getRequirements()) {
            i = Math.max(i, this.getIndent(requirement.getProperty()));
        }
        if (!property.getRequirements().isEmpty()) {
            ++i;
        }
        return i;
    }

    private void selectFile(Property property) {
        final org.opt4j.core.config.annotations.File file = property.getAnnotation(org.opt4j.core.config.annotations.File.class);
        JFileChooser fileChooser = this.fileChooser.get();
        File dir = null;
        try {
            dir = new File(property.getValue().toString());
        }
        catch (Exception ex) {
            // empty catch block
        }
        fileChooser.setCurrentDirectory(dir);
        if (file != null && !file.value().equals("")) {
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String ext;
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    String f = pathname.getName().toLowerCase();
                    return f.endsWith(ext = file.value().toLowerCase());
                }

                @Override
                public String getDescription() {
                    String ext = file.value().toLowerCase();
                    return "(*" + ext + ")";
                }
            };
            fileChooser.setFileFilter(filter);
        } else {
            fileChooser.setFileFilter(null);
        }
        fileChooser.setVisible(true);
        int status = fileChooser.showOpenDialog(null);
        if (status == 0) {
            File f = fileChooser.getSelectedFile();
            try {
                property.setValue(f.getAbsolutePath());
                JTextField field = (JTextField)this.components.get(property);
                field.setText("" + property.getValue());
                this.update();
            }
            catch (InvocationTargetException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

