/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.opt4j.core.config.Icons;
import org.opt4j.core.config.ModuleSaver;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.annotations.Panel;
import org.opt4j.core.config.visualization.ClipboardFrame;
import org.opt4j.core.config.visualization.FileChooser;
import org.opt4j.core.config.visualization.Format;
import org.opt4j.core.config.visualization.ModuleTransferable;
import org.opt4j.core.config.visualization.PropertyPanel;
import org.opt4j.core.config.visualization.SelectedModules;
import org.opt4j.core.config.visualization.SelectedPanel;
import org.opt4j.core.config.visualization.SetListener;

public class DefaultSelectedPanel
extends SelectedPanel
implements SetListener {
    protected final TabbedPane tabs = new TabbedPane();
    protected final Format format;
    protected final SelectedModules selectedModules;
    protected final FileChooser fileChooser;
    protected final Map<PropertyModule, PropertyPanel> map = new HashMap<PropertyModule, PropertyPanel>();
    protected final DropTarget dropTarget;
    protected final DropTargetListener dropListener = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            DataFlavor flaver = ModuleTransferable.localModuleFlavor;
            try {
                if (transferable.isDataFlavorSupported(flaver)) {
                    Object o = transferable.getTransferData(flaver);
                    PropertyModule module = (PropertyModule)o;
                    DefaultSelectedPanel.this.selectedModules.add(module);
                    dtde.acceptDrop(2);
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };

    @Inject
    public DefaultSelectedPanel(Format format, SelectedModules selectedModules, FileChooser fileChooser) {
        this.format = format;
        this.selectedModules = selectedModules;
        this.fileChooser = fileChooser;
        this.dropTarget = new DropTarget(this, this.dropListener);
    }

    @Inject
    public void init() {
        this.selectedModules.addListener(this);
    }

    @Override
    public void startup() {
        this.setLayout(new BorderLayout());
        this.add(this.tabs);
    }

    protected void addModule(PropertyModule module) {
        if (!this.map.keySet().contains(module)) {
            PropertyPanel panel = null;
            Panel p = module.getModule().getClass().getAnnotation(Panel.class);
            if (p != null) {
                Class<? extends PropertyPanel> clazz = p.value();
                try {
                    Constructor<? extends PropertyPanel> cstr = clazz.getConstructor(PropertyModule.class, FileChooser.class, Format.class);
                    panel = cstr.newInstance(module, this.fileChooser, this.format);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                panel = new PropertyPanel(module, this.fileChooser, this.format);
            }
            MyScrollPane scroll = new MyScrollPane(panel);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setPreferredSize(new Dimension(300, 300));
            String name = this.format.getName(module);
            String tooltip = this.format.getTooltip(module);
            int count = this.selectedModules.subSet(this.selectedModules.first(), module).size();
            this.tabs.insertTab(name, null, scroll, tooltip, count);
            this.tabs.setSelectedIndex(count);
            this.tabs.setTabComponentAt(count, new TabComponent(module));
            this.map.put(module, panel);
        } else {
            int index = this.tabs.getIndex(module);
            if (index != -1) {
                this.tabs.setSelectedIndex(index);
            }
        }
        this.updateTabNames();
    }

    protected void removeModule(PropertyModule module) {
        int index = this.tabs.getIndex(module);
        if (index != -1) {
            this.map.remove(module);
            this.tabs.remove(index);
        }
        this.updateTabNames();
    }

    /*
     * WARNING - void declaration
     */
    protected void updateTabNames() {
        void var4_7;
        HashSet<Class> exist = new HashSet<Class>();
        HashSet<Class> multi = new HashSet<Class>();
        for (PropertyModule propertyModule : this.map.keySet()) {
            Class module = propertyModule.getModule().getClass();
            if (exist.contains(module)) {
                multi.add(module);
                continue;
            }
            exist.add(module);
        }
        HashMap counter = new HashMap();
        for (Class module : multi) {
            counter.put(module, 1);
        }
        boolean bl = false;
        while (var4_7 < this.tabs.getTabCount()) {
            TabComponent comp = (TabComponent)this.tabs.getTabComponentAt((int)var4_7);
            Class<?> module = comp.getModule().getModule().getClass();
            if (counter.containsKey(module)) {
                int c = (Integer)counter.get(module);
                String name = "(" + c + ") " + this.format.getName(comp.getModule());
                comp.setLabelName(name);
                counter.put(module, c + 1);
            }
            ++var4_7;
        }
        this.tabs.repaint();
    }

    @Override
    public void moduleAdded(Collection<PropertyModule> collection, PropertyModule module) {
        this.addModule(module);
    }

    @Override
    public void moduleRemoved(Collection<PropertyModule> collection, PropertyModule module) {
        this.removeModule(module);
    }

    protected class TabComponent
    extends JPanel {
        private JLabel label;
        private final JButton xmlButton;
        private final JButton closeButton;
        private final PropertyModule module;
        private final MouseListener buttonMouseListener;

        public TabComponent(PropertyModule module) {
            super(new FlowLayout(0, 0, 0));
            this.buttonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Component component = e.getComponent();
                    if (component instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)component;
                        button.setBorderPainted(false);
                    }
                }
            };
            this.module = module;
            this.setOpaque(false);
            String name = DefaultSelectedPanel.this.format.getName(module);
            ImageIcon icon = DefaultSelectedPanel.this.format.getIcon(module);
            this.label = new JLabel(name, icon, 2);
            this.xmlButton = new XMLButton();
            this.xmlButton.setToolTipText("Show module xml");
            this.closeButton = new CloseButton();
            this.closeButton.setToolTipText("Remove module");
            this.setLabelName(name);
        }

        protected void setLabelName(String name) {
            if (name.length() > 22) {
                name = name.substring(0, 18) + "...";
            }
            this.label.setName(name);
            this.removeAll();
            this.label = new JLabel(this.label.getName(), this.label.getIcon(), 2);
            this.add(this.label);
            this.add(new JLabel(" "));
            this.label.setBorder(BorderFactory.createEmptyBorder(0, this.label.getIcon() == null ? 5 : 0, 0, 5));
            this.add(this.xmlButton);
            this.add(this.closeButton);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        }

        protected PropertyModule getModule() {
            return this.module;
        }

        private class XMLButton
        extends TabButton {
            private XMLButton() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleSaver saver = new ModuleSaver();
                ClipboardFrame frame = new ClipboardFrame(saver.toXMLString(TabComponent.this.module));
                frame.pack();
                frame.setVisible(true);
            }

            @Override
            protected void drawIcon(Graphics2D g) {
                g.setStroke(new BasicStroke(1.0f));
                Image image = Icons.getIcon("icons/xmltag.png").getImage();
                g.drawImage(image, 0, -1, 15, 16, this);
            }
        }

        private class CloseButton
        extends TabButton {
            private CloseButton() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = DefaultSelectedPanel.this.tabs.indexOfTabComponent(TabComponent.this);
                if (i != -1) {
                    DefaultSelectedPanel.this.selectedModules.remove(TabComponent.this.module);
                }
            }

            @Override
            protected void drawIcon(Graphics2D g) {
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(Color.RED);
                int delta = 5;
                g.drawLine(delta, delta, this.getWidth() - delta - 2, this.getHeight() - delta - 2);
                g.drawLine(this.getWidth() - delta - 2, delta, delta, this.getHeight() - delta - 2);
            }
        }

        private abstract class TabButton
        extends JButton
        implements ActionListener {
            protected static final int SIZE = 16;

            TabButton() {
                this.setPreferredSize(new Dimension(16, 16));
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.addMouseListener(TabComponent.this.buttonMouseListener);
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                this.drawIcon(g2);
                g2.dispose();
            }

            protected abstract void drawIcon(Graphics2D var1);
        }
    }

    protected class TabbedPane
    extends JTabbedPane {
        protected TabbedPane() {
        }

        @Override
        public void remove(int index) {
            Component component = DefaultSelectedPanel.this.tabs.getComponentAt(index);
            super.remove(index);
            if (component instanceof MyScrollPane) {
                MyScrollPane scroll = (MyScrollPane)component;
                DefaultSelectedPanel.this.map.remove(scroll.getPanel().getModule());
            }
        }

        protected int getIndex(PropertyModule module) {
            if (DefaultSelectedPanel.this.map.keySet().contains(module)) {
                for (int i = 0; i < DefaultSelectedPanel.this.tabs.getTabCount(); ++i) {
                    MyScrollPane scroll;
                    Component component = DefaultSelectedPanel.this.tabs.getComponentAt(i);
                    if (!(component instanceof MyScrollPane) || !(scroll = (MyScrollPane)component).getPanel().getModule().equals(module)) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    protected static class MyScrollPane
    extends JScrollPane {
        PropertyPanel panel;

        public MyScrollPane(PropertyPanel panel) {
            super(panel);
            this.panel = panel;
        }

        public PropertyPanel getPanel() {
            return this.panel;
        }
    }
}

